#include <pthread.h>
#include <starlet.h>
#include <string.h>

#include "wl_def.h"
#include "id_ca.h"

boolean 			AdLibPresent;
boolean				SoundBlasterPresent;

SDMode 				SoundMode;
SDMode				MusicMode;
SDSMode 			DigiMode;
soundnames			PlayingSound;

static boolean			SD_Started;

boolean				SD_StartSoundThread(void);

pthread_t			soundthread;
pthread_attr_t			soundthreadattr;
pthread_cond_t			soundthreadcond;
pthread_mutex_t			soundthreadmutex;

void SD_SetDigiDevice(SDSMode mode)
{
    return;
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_SetSoundMode() - Sets which sound hardware to use for sound effects
//
///////////////////////////////////////////////////////////////////////////
boolean SD_SetSoundMode(SDMode mode)
{
    boolean			sstatus;

    if (mode == sdm_Off || mode == sdm_PC)
    {
	CA_UnLoadAllSounds();
	SoundMode = mode;
	sstatus = true;
    }
    else
	sstatus = false;

    return(sstatus);
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_SetMusicMode() - sets the device to use for background music
//
///////////////////////////////////////////////////////////////////////////
boolean SD_SetMusicMode(SMMode mode)
{
	return false;
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_Startup() - starts up the Sound Mgr
//
///////////////////////////////////////////////////////////////////////////
void SD_Startup(void)
{
    extern void			SD_StartXBell();

    int				sstatus;

    if (SD_Started)
	return;

    /* Initialization */
    sstatus = SS$_NORMAL;
    AdLibPresent = false;
    SoundBlasterPresent = false;
    SoundMode = sdm_Off;
    MusicMode = smm_Off;
    DigiMode = sds_PC;

    InitDigiMap();

    /* Program */
#ifdef __VAX
    // VAX startup function
#else
    // Alpha startup function...
#endif
    SD_StartXBell();


    sstatus = SD_StartSoundThread();
    if (!sstatus)
    {
	printf("SD_SoundStartup: Failed sound startup; disabling sound\n");
	// disable sound here...
    }

    SD_Started = true;

    return;
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_Shutdown() - shuts down the Sound Mgr
//
///////////////////////////////////////////////////////////////////////////
void SD_Shutdown(void)
{
    int				sstatus;

    if (!SD_Started)
	return;

    sstatus = pthread_cancel(soundthread);
    if (sstatus != 0)
    {
	printf("SD_Shutdown: Failed to cancel sound thread\n");
	printf("SD_Shutdown: (reason) %s\n", strerror(sstatus));
    }

#ifdef __VAX
    // VAX shutdown route...
#else
    // Alpha shutdown routine...
#endif

    SD_Started = false;
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_PlaySound() - plays the specified sound on the appropriate hardware
//
///////////////////////////////////////////////////////////////////////////
boolean SD_PlaySound(soundnames sound)
{
    int				sstatus;

    if(SoundMode != sdm_Off)
    {
//	if (DigiMap[sound] != -1)
	{
	    PlayingSound = sound;

#ifdef __VAX
	    // if SoundMode == sdm_AdLib
		// SD_PlayVAX
	    // if SoundMode == sdm_PC
	    {
#endif /* __VAX */

		sstatus = pthread_cond_signal(&soundthreadcond);
		if (sstatus != 0)
		{
		    printf("SD_PlaySound: Failed to send condition signal to "
			   "thread\n");
		    printf("SD_PlaySound: (reason) %s\n", strerror(sstatus));
		}

#ifdef __VAX
	    }
#endif /* __VAX */
	}
    }

    return(true);
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_SoundPlaying() - returns the sound number that's playing, or 0 if
//		no sound is playing
//
///////////////////////////////////////////////////////////////////////////
word SD_SoundPlaying(void)
{
    if (PlayingSound == -1)
	return(0);
    else
	return(PlayingSound);
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_StopSound() - if a sound is playing, stops it
//
///////////////////////////////////////////////////////////////////////////
void SD_StopSound(void)
{
    PlayingSound = -1;

    return;
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_WaitSoundDone() - waits until the current sound is done playing
//
///////////////////////////////////////////////////////////////////////////
void SD_WaitSoundDone(void)
{
/* TODO: should also "work" when sound is disabled... */
	while (SD_SoundPlaying())
		;
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_MusicOn() - turns on the sequencer
//
///////////////////////////////////////////////////////////////////////////
void SD_MusicOn(void)
{
    return;
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_MusicOff() - turns off the sequencer and any playing notes
//
///////////////////////////////////////////////////////////////////////////
void SD_MusicOff(void)
{
    return;
}

///////////////////////////////////////////////////////////////////////////
//
//	SD_StartMusic() - starts playing the music pointed to
//
///////////////////////////////////////////////////////////////////////////
void SD_StartMusic(int music)
{
    SD_MusicOff();
}

void PlaySoundLocGlobal(word s, int id, fixed gx,fixed gy)
{
    SD_PlaySound(s);
}

void UpdateSoundLoc(fixed x, fixed y, int angle)
{
    return;
}

void *SD_SoundThread(void *arg)
{
    extern void			SD_PlayXBell();

    int				cont;
    int				sstatus;

    sstatus = pthread_mutex_lock(&soundthreadmutex);
    if (sstatus != 0)
    {
	printf("SD_SoundThread: Failed to lock thread mutex\n");
	printf("SD_SoundThread: (reason) %s\n", strerror(sstatus));
    }
    else
    {
	cont = 1;
	while (cont)
	{
	    sstatus = pthread_cond_wait(&soundthreadcond, &soundthreadmutex);
	    if (sstatus != 0)
	    {
		printf("SD_SoundThread: Error in call to "
		       "pthread_cond_wait()\n");
		printf("SD_SoundThread: (reason) %s\n", strerror(sstatus));

		cont = 0;
	    }
	    else
	    {
		if (SoundMode == sdm_PC)
		    SD_PlayXBell(PlayingSound);

	    }

	    PlayingSound = -1;
	}
    }

    return(NULL);
}

boolean SD_StartSoundThread(void)
{
    int				sstatus;

    sstatus = pthread_attr_init(&soundthreadattr);
    if (sstatus != 0)
    {
	printf("SD_StartSoundThread: Error initializing sound thread "
	       "attributes\n");
	printf("SD_StartSoundThread: (reason) %s\n", strerror(sstatus));
    }
    else
    {
	sstatus = pthread_attr_setdetachstate(&soundthreadattr,
					      PTHREAD_CREATE_DETACHED);
	if (sstatus != 0)
	{
	    printf("SD_StartSoundThread: Error setting destroy attribute\n");
	    printf("SD_StartSoundThread: (reason) %s\n", strerror(sstatus));
	}
	else
	{
	    sstatus = pthread_mutex_init(&soundthreadmutex, NULL);
	    if (sstatus != 0)
	    {
		printf("SD_StartSoundThread: Failed to initialize mutex\n");
		printf("SD_StartSoundThread: (reason) %s\n",
		       strerror(sstatus));
	    }
	    else
	    {
		sstatus = pthread_cond_init(&soundthreadcond, NULL);
		if (sstatus != 0)
		{
		    printf("SD_StartSoundThread: Failed to initialize "
			   "condition value\n");
		    printf("SD_StartSoundThread: (reason) %s\n",
			   strerror(sstatus));
		}
		else
		{
		    sstatus = pthread_create(&soundthread, &soundthreadattr,
					     SD_SoundThread, NULL);
		    if (sstatus != 0)
		    {
			printf("SD_StartSoundThread: Failed to start sound "
			       "thread\n");
			printf("SD_StartSoundThread: (reason) %s\n",
			       strerror(sstatus));
		    }
		}
	    } /* pthread_mutex_init() */
	} /* pthread_attr_setdetachstate() */

	sstatus = pthread_attr_destroy(&soundthreadattr);
	if (sstatus != 0)
	{
	    printf("SD_StartSoundThread: Failed to destroy thread attribute "
		   "object\n");
	    printf("SD_StartSoundThread: (reason) %s\n", strerror(sstatus));
	}

    } /* pthread_attr_init() */

    if (sstatus == 0)
	sstatus = true;
    else
	sstatus = false;

    return(sstatus);
}
