$! (c) Alexey Chupahin  12-NOV-2007
$! GNU
$! elvis_75@mail.ru
$!
$ SET NOON
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Configuring SDL_Mixer library"
$WRITE SYS$OUTPUT "(c) Alexey Chupahin aka CHAPG"
$WRITE SYS$OUTPUT " "
$! Checking architecture
$DECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$    IF F$GETSYI("ARCH_TYPE").EQ.1 THEN CPU = "VAX"
$    IF F$GETSYI("ARCH_TYPE").EQ.2 THEN CPU = "Alpha"
$    IF F$GETSYI("ARCH_TYPE").EQ.3 THEN CPU = "I64"
$    OS = F$GETSYI("VERSION")
$WRITE SYS$OUTPUT "Checking architecture   ...  ", CPU
$WRITE SYS$OUTPUT "Checking OS             ...  OpenVMS ",OS
$SHARED=0
$IF ( (CPU.EQS."Alpha").OR.(CPU.EQS."I64") )
$  THEN
$       SHARED=64
$  ELSE
$       SHARED=32
$ENDIF
$!
$! VAX is not supported: have no 64-bit  long long type 
$!IF (CPU.EQS."VAX")
$!  THEN
$!	TYPE SYS$OUTPUT " OpenVMS VAX is not supported due to absent 64-bit integer long long type"
$!	GOTO EXIT
$!ENDIF
$!
$IF (DECC) THEN $WRITE SYS$OUTPUT  "Compiler		...  DEC C"
$IF (.NOT. DECC) THEN $WRITE SYS$OUTPUT  "BAD compiler" GOTO EXIT
$MMS = F$SEARCH("SYS$SYSTEM:MMS.EXE") .NES. ""
$MMK = F$TYPE(MMK) 
$IF (MMS .OR. MMK.NES."") THEN GOTO TEST_LIBRARIES
$! I cant find any make tool
$GOTO EXIT
$!
$!
$TEST_LIBRARIES:
$!   Setting as MAKE utility one of MMS or MMK. I prefer MMS.
$IF (MMK.NES."") THEN MAKE="MMK"
$IF (MMS) THEN MAKE="MMS/ignore=warning"
$WRITE SYS$OUTPUT "Checking build utility	...  ''MAKE'"
$WRITE SYS$OUTPUT " "
$!
$!
$!"Checking for correct SDL library"
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ LIBSDL_STATIC=0
$ CC/name=(as_is,short)/float=ieee/OBJECT=TEST.OBJ/INCLUDE=(SDL) SYS$INPUT
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>

int main(int argc, char *argv[])
{
        SDL_version compiled;

        /* Initialize SDL */
        if ( SDL_Init(0) < 0 ) {
                fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());                exit(2);
        }
#ifdef DEBUG
        fprintf(stderr, "SDL initialized\n");
#endif
#if SDL_VERSION_ATLEAST(1, 2, 14)
#elif defined (VMS_PATCH)
        printf("checking version libSDL  : %d.%d.%d%s\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch,
                                VMS_PATCH);
        SDL_Quit();
        return(0);
#else
        printf("This version is too old. Please get newest\n");
        printf("From fafner.dyndns.org/~alexey/libsdl/public.html\n");
	exit(2);
#endif
        printf("checking version libSDL  : %d.%d.%d\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch);
        SDL_Quit();
        return(0);
}

$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_LIBSDL=0
$       GOTO NEXT0
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,LIBSDL:LIBSDL$SHR/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001)
$  THEN
$       LINK/EXE=TEST TEST,LIBSDL:LIBSDL/OPT
$       TMP = $STATUS
$       IF (TMP .NE. %X10000001 .and. tmp .ne. %X10648268 )
$         THEN
$               TMP = $STATUS
$               HAVE_LIBSDL=0
$               GOTO NEXT0
$         ELSE
$               LIBSDL_STATIC=1
$       ENDIF
$ENDIF
$!
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$       HAVE_LIBSDL=0
$	GOTO NEXT0
$  ELSE
$        HAVE_LIBSDL=1
$ENDIF
$DEAS  SYS$ERROR
$NEXT0:
$IF (HAVE_LIBSDL.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   No"
$	GOTO EXIT
$ENDIF
$!
$!
$!
$IF (LIBSDL_STATIC.NE.1)
$  THEN
$	OPEN/WRITE OUT LIBSDL_MIXER$SHR.OPT
$	WRITE OUT "SYS$SHARE:LIBSDL_MIXER$SHR/SHARE"
$	CLOSE OUT
$  ELSE
$	OPEN/WRITE OUT LIBSDL_MIXER.OPT
$ 	WRITE OUT "LIBSDL_MIXER:LIBSDL_MIXER/LIB"
$	CLOSE  OUT
$ENDIF
$!Append OPT files to LIBSDL_MIXER.OPT
$!
$OPEN/WRITE OUT BUILD.COM
$ WRITE OUT "$",MAKE," ALL"
$ WRITE OUT "$ CURRENT = F$ENVIRONMENT (""DEFAULT"") "
$ WRITE OUT "$TMP=CURRENT"
$ WRITE OUT "$OPEN/WRITE OUTT LIBSDL_MIXER$STARTUP.COM"
$ WRITE OUT "$WRITE OUTT ""DEFINE LIBSDL_MIXER ","'","'","TMP'""
$!
$ WRITE OUT "$WRITE SYS$OUTPUT "" ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""LIBSDL_MIXER$STARTUP.COM has been created. ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""This file setups all logicals needed. It should be execute before using ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""Nice place to call it - LOGIN.COM ""
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** """
$ IF (LIBSDL_STATIC.EQ.1)
$   THEN
$       WRITE OUT "$WRITE SYS$OUTPUT ""Important! You are using static library of libSDL. To compile a project with libSDL_MIXER you should: """
$       WRITE OUT "$WRITE SYS$OUTPUT ""CC/INCL=(SDL,LIBSDL_MIXER) PROJECT.C"""
$       WRITE OUT "$WRITE SYS$OUTPUT ""LINK/THREAD=UP PROJECT,LIBSDL_MIXER:LIBSDL_MIXER/OPT,LIBSDL:LIBSDL/OPT"" "
$   ELSE
$       WRITE OUT "$WRITE SYS$OUTPUT ""Important! You are using shared library of libSDL. To compile a project with libSDL_MIXER you should: "" "
$       WRITE OUT "$WRITE SYS$OUTPUT ""CC/INCL=(SDL,LIBSDL_MIXER) PROJECT.C"" "
$       WRITE OUT "$WRITE SYS$OUTPUT ""LINK/THREAD=UP  PROJECT,LIBSDL_MIXER:LIBSDL_MIXER$SHR/OPT,LIBSDL:LIBSDL$SHR/OPT"" "
$ENDIF
$CLOSE OUT
$!
$COP SYS$INPUT DESCRIP.MMS
# (c) Alexey Chupahin 01-OCT-2007
# OpenVMS 7.3-1, DEC 2000 mod.300
# OpenVMS 8.3,   HP rx1620

.FIRST
	DEF LIBSDL_MIXER []

        set def [.MIKMOD]
        $(mms)
        set def [-.NATIVE_MIDI]
        $(mms)
#       set def [-.NATIVE_MIDI_GPL]
#       $(mms)
        set def [-.TIMIDITY]
        $(mms)
        set def [-]
CC=cc

CFLAGS = /NOWARN /INCLUDE=([],[-.include], SDL, X11:)  /DEB \
/name=(as_is,short)/float=ieee/OPTIMIZE=(INLINE=SPEED)

OBJ=\
dynamic_mp3.obj,\
dynamic_ogg.obj,\
effects_internal.obj,\
effect_position.obj,\
effect_stereoreverse.obj,\
load_aiff.obj,\
load_ogg.obj,\
load_voc.obj,\
mixer.obj,\
music.obj,\
music_cmd.obj,\
music_mad.obj,\
music_ogg.obj,\
wavestream.obj
 

LIBSDL_MIXER.OLB : $(OBJ)
        lib/crea []LIBSDL_MIXER.OLB $(OBJ)

PLAYMUS.OBJ : PLAYMUS.C
        cc $(CFLAGS) PLAYMUS

PLAYMUS.EXE : PLAYMUS.OBJ
        link/thread=up []PLAYMUS.OBJ,[]LIBSDL_MIXER/LIB,LIBSDL:LIBSDL$SHR/OPT

PLAYWAVE.OBJ : PLAYWAVE.C
        cc $(CFLAGS) PLAYWAVE

PLAYWAVE.EXE : PLAYWAVE.OBJ
        link/thread=up []PLAYWAVE.OBJ,[]LIBSDL_MIXER/LIB,LIBSDL:LIBSDL$SHR/OPT
 
$!
$IF (LIBSDL_STATIC.EQ.1)
$  THEN
$	APP SYS$INPUT DESCRIP.MMS

ALL : LIBSDL_MIXER.OLB, PLAYMUS.EXE, PLAYWAVE.EXE
	$!
$!
$  ELSE
$	APP SYS$INPUT DESCRIP.MMS
SDL_MIXER$SHR.EXE : LIBSDL_MIXER.OLB
	LINK/SHARE=SDL_MIXER$SHR.EXE []MIXER,[]LIBSDL_MIXER/OPT, []LIBMIKMOD/LIB,[]LIB_NATIVE_MIDI/LIB,[]LIB_TIMIDITY/LIB,LIBSDL:LIBSDL$SHR/OPT, []LIBSDL_MIXER$DEF/OPT
        COPY SDL_MIXER$SHR.EXE SYS$SHARE

ALL : LIBSDL_MIXER.OLB, PLAYMUS.EXE, PLAYWAVE.EXE, SDL_MIXER$SHR.EXE
	$!

$ENDIF
$APP SYS$INPUT DESCRIP.MMS

dynamic_mp3.obj : dynamic_mp3.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

dynamic_ogg.obj : dynamic_ogg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

effects_internal.obj : effects_internal.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

effect_position.obj : effect_position.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

effect_stereoreverse.obj : effect_stereoreverse.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_aiff.obj : load_aiff.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_ogg.obj : load_ogg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_voc.obj : load_voc.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mixer.obj : mixer.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

music.obj : music.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

music_cmd.obj : music_cmd.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

music_mad.obj : music_mad.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

music_ogg.obj : music_ogg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

wavestream.obj : wavestream.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)
 
$!
$! DESCRIP.MMS in MIKMOD
$COPY SYS$INPUT [.MIKMOD]DESCRIP.MMS
#
# Generated by CONFIGURE.COM
# Alexey Chupahin elvis_75@mail.ru

CFLAGS = /INCLUDE=([],[-.include], SDL, X11:) /DEB \
/name=(as_is,short)/float=ieee/OPTIMIZE=(INLINE=SPEED) /WARNING=(DIS=EXTRASEMI)

OBJ = \
drv_nos.obj,\
load_it.obj,\
load_mod.obj,\
load_s3m.obj,\
load_xm.obj,\
mdreg.obj,\
mdriver.obj,\
mloader.obj,\
mlreg.obj,\
mlutil.obj,\
mmalloc.obj,\
mmerror.obj,\
mmio.obj,\
mplayer.obj,\
munitrk.obj,\
mwav.obj,\
npertab.obj,\
sloader.obj,\
virtch.obj,\
virtch2.obj,\
virtch_common.obj

ALL : LIBMIKMOD.OLB
	$COPY LIBMIKMOD.OLB [-]

LIBMIKMOD.OLB : $(OBJ)
        lib/crea []LIBMIKMOD.OLB $(OBJ)

drv_nos.obj : drv_nos.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_it.obj : load_it.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_mod.obj : load_mod.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_s3m.obj : load_s3m.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_xm.obj : load_xm.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mdreg.obj : mdreg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mdriver.obj : mdriver.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mloader.obj : mloader.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mlreg.obj : mlreg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mlutil.obj : mlutil.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mmalloc.obj : mmalloc.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mmerror.obj : mmerror.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mmio.obj : mmio.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mplayer.obj : mplayer.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

munitrk.obj : munitrk.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mwav.obj : mwav.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

npertab.obj : npertab.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sloader.obj : sloader.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

virtch.obj : virtch.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

virtch2.obj : virtch2.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

virtch_common.obj : virtch_common.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)
 

$!
$! DESCRIP.MMS in NATIVE_MIDI
$COPY SYS$INPUT [.NATIVE_MIDI]DESCRIP.MMS
# Generated by CONFIGURE.COM
# Alexey Chupahin elvis_75@mail.ru
#
#

CFLAGS = /NOWARN /INCLUDE=([],[-],[-.-.include], SDL, X11:) /NAME=SHORT /DEB \
/name=(as_is,short)/float=ieee/OPTIMIZE=(INLINE=SPEED)

OBJ = \
native_midi_common.obj

ALL : LIB_NATIVE_MIDI.OLB
	$COPY LIB_NATIVE_MIDI.OLB [-]

LIB_NATIVE_MIDI.OLB : $(OBJ)
        lib/crea []LIB_NATIVE_MIDI.OLB $(OBJ)

native_midi_common.obj : native_midi_common.c
	$(CC) $(CFLAGS) native_midi_common
$!
$! 
$! DESCRIP.MMS in TIMIDITY
$COPY SYS$INPUT [.TIMIDITY]DESCRIP.MMS
# Generated by CONFIGURE.COM
# Alexey Chupahin elvis_75@mail.ru
#
#


CFLAGS = /INCLUDE=([],[-],[-.-.include], SDL, X11:) /NAME=SHORT /DEB \
/name=(as_is,short)/float=ieee/OPTIMIZE=(INLINE=SPEED)

OBJ = \
common.obj,\
ctrlmode.obj,\
filter.obj,\
instrum.obj,\
mix.obj,\
output.obj,\
playmidi.obj,\
readmidi.obj,\
resample.obj,\
sdl_a.obj,\
sdl_c.obj,\
tables.obj,\
timidity.obj
  
ALL : LIB_TIMIDITY.OLB
	COPY LIB_TIMIDITY.OLB [-]

LIB_TIMIDITY.OLB : $(OBJ)
        lib/crea []LIB_TIMIDITY.OLB $(OBJ)

common.obj : common.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

ctrlmode.obj : ctrlmode.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

filter.obj : filter.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

instrum.obj : instrum.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mix.obj : mix.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

output.obj : output.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

playmidi.obj : playmidi.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

readmidi.obj : readmidi.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

resample.obj : resample.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_a.obj : sdl_a.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_c.obj : sdl_c.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tables.obj : tables.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

timidity.obj : timidity.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

$!
$!
$DEAS SYS$OUTPUT
$IF (LIBSDL_STATIC.NE.1)
$  THEN
$	WRITE SYS$OUTPUT "generating LIBSDL_MIXER$SHR.OPT"
$	COPY SYS$INPUT LIBSDL_MIXER$SHR.OPT
SYS$SHARE:SDL_MIXER$SHR/SHARE
$ENDIF
$WRITE SYS$OUTPUT "generating LIBSDL_MIXER.OPT"
$COPY SYS$INPUT LIBSDL_MIXER.OPT
LIBSDL_MIXER:LIBSDL_MIXER/LIB
$!
$WRITE SYS$OUTPUT "generating LIBSDL_MIXER$DEF.OPT"
$IF (SHARED.EQ.64)
$  THEN
$       COPY SYS$INPUT LIBSDL_MIXER$DEF.OPT
case_sensitive=YES
SYMBOL_VECTOR = (Mix_Linked_Version=PROCEDURE,-
Mix_OpenAudio=PROCEDURE,-
Mix_AllocateChannels=PROCEDURE,-
Mix_QuerySpec=PROCEDURE,-
Mix_LoadWAV_RW=PROCEDURE,-
Mix_LoadMUS=PROCEDURE,-
Mix_LoadMUS_RW=PROCEDURE,-
Mix_QuickLoad_WAV=PROCEDURE,-
Mix_QuickLoad_RAW=PROCEDURE,-
Mix_FreeChunk=PROCEDURE,-
Mix_FreeMusic=PROCEDURE,-
Mix_GetMusicType=PROCEDURE,-
Mix_SetPostMix=PROCEDURE,-
Mix_HookMusic=PROCEDURE,-
Mix_HookMusicFinished=PROCEDURE,-
Mix_GetMusicHookData=PROCEDURE,-
Mix_ChannelFinished=PROCEDURE,-
Mix_RegisterEffect=PROCEDURE,-
Mix_UnregisterEffect=PROCEDURE,-
Mix_UnregisterAllEffects=PROCEDURE,-
Mix_SetPanning=PROCEDURE,-
Mix_SetPosition=PROCEDURE,-
Mix_SetDistance=PROCEDURE,-
Mix_SetReverseStereo=PROCEDURE,-
Mix_ReserveChannels=PROCEDURE,-
Mix_GroupChannel=PROCEDURE,-
Mix_GroupChannels=PROCEDURE,-
Mix_GroupAvailable=PROCEDURE,-
Mix_GroupCount=PROCEDURE,-
Mix_GroupOldest=PROCEDURE,-
Mix_GroupNewer=PROCEDURE,-
Mix_PlayChannelTimed=PROCEDURE,-
Mix_PlayMusic=PROCEDURE,-
Mix_FadeInMusic=PROCEDURE,-
Mix_FadeInMusicPos=PROCEDURE,-
Mix_FadeInChannelTimed=PROCEDURE,-
Mix_Volume=PROCEDURE,-
Mix_VolumeChunk=PROCEDURE,-
Mix_VolumeMusic=PROCEDURE,-
Mix_HaltChannel=PROCEDURE,-
Mix_HaltGroup=PROCEDURE,-
Mix_HaltMusic=PROCEDURE,-
Mix_ExpireChannel=PROCEDURE,-
Mix_FadeOutChannel=PROCEDURE,-
Mix_FadeOutGroup=PROCEDURE,-
Mix_FadeOutMusic=PROCEDURE,-
Mix_FadingMusic=PROCEDURE,-
Mix_FadingChannel=PROCEDURE,-
Mix_Pause=PROCEDURE,-
Mix_Resume=PROCEDURE,-
Mix_Paused=PROCEDURE,-
Mix_PauseMusic=PROCEDURE,-
Mix_ResumeMusic=PROCEDURE,-
Mix_RewindMusic=PROCEDURE,-
Mix_PausedMusic=PROCEDURE,-
Mix_SetMusicPosition=PROCEDURE,-
Mix_Playing=PROCEDURE,-
Mix_PlayingMusic=PROCEDURE,-
Mix_SetMusicCMD=PROCEDURE,-
Mix_SetSynchroValue=PROCEDURE,-
Mix_GetSynchroValue=PROCEDURE,-
Mix_GetChunk=PROCEDURE,-
Mix_CloseAudio=PROCEDURE-
)

$  ELSE
$	COPY SYS$INPUT LIBSDL_MIXER$DEF.OPT
UNIVERSAL=Mix_Linked_Version
UNIVERSAL=Mix_OpenAudio
UNIVERSAL=Mix_AllocateChannels
UNIVERSAL=Mix_QuerySpec
UNIVERSAL=Mix_LoadWAV_RW
UNIVERSAL=Mix_LoadMUS
UNIVERSAL=Mix_LoadMUS_RW
UNIVERSAL=Mix_QuickLoad_WAV
UNIVERSAL=Mix_QuickLoad_RAW
UNIVERSAL=Mix_FreeChunk
UNIVERSAL=Mix_FreeMusic
UNIVERSAL=Mix_GetMusicType
UNIVERSAL=Mix_SetPostMix
UNIVERSAL=Mix_HookMusic
UNIVERSAL=Mix_HookMusicFinished
UNIVERSAL=Mix_GetMusicHookData
UNIVERSAL=Mix_ChannelFinished
UNIVERSAL=Mix_RegisterEffect
UNIVERSAL=Mix_UnregisterEffect
UNIVERSAL=Mix_UnregisterAllEffects
UNIVERSAL=Mix_SetPanning
UNIVERSAL=Mix_SetPosition
UNIVERSAL=Mix_SetDistance
UNIVERSAL=Mix_SetReverseStereo
UNIVERSAL=Mix_ReserveChannels
UNIVERSAL=Mix_GroupChannel
UNIVERSAL=Mix_GroupChannels
UNIVERSAL=Mix_GroupAvailable
UNIVERSAL=Mix_GroupCount
UNIVERSAL=Mix_GroupOldest
UNIVERSAL=Mix_GroupNewer
UNIVERSAL=Mix_PlayChannelTimed
UNIVERSAL=Mix_PlayMusic
UNIVERSAL=Mix_FadeInMusic
UNIVERSAL=Mix_FadeInMusicPos
UNIVERSAL=Mix_FadeInChannelTimed
UNIVERSAL=Mix_Volume
UNIVERSAL=Mix_VolumeChunk
UNIVERSAL=Mix_VolumeMusic
UNIVERSAL=Mix_HaltChannel
UNIVERSAL=Mix_HaltGroup
UNIVERSAL=Mix_HaltMusic
UNIVERSAL=Mix_ExpireChannel
UNIVERSAL=Mix_FadeOutChannel
UNIVERSAL=Mix_FadeOutGroup
UNIVERSAL=Mix_FadeOutMusic
UNIVERSAL=Mix_FadingMusic
UNIVERSAL=Mix_FadingChannel
UNIVERSAL=Mix_Pause
UNIVERSAL=Mix_Resume
UNIVERSAL=Mix_Paused
UNIVERSAL=Mix_PauseMusic
UNIVERSAL=Mix_ResumeMusic
UNIVERSAL=Mix_RewindMusic
UNIVERSAL=Mix_PausedMusic
UNIVERSAL=Mix_SetMusicPosition
UNIVERSAL=Mix_Playing
UNIVERSAL=Mix_PlayingMusic
UNIVERSAL=Mix_SetMusicCMD
UNIVERSAL=Mix_SetSynchroValue
UNIVERSAL=Mix_GetSynchroValue
UNIVERSAL=Mix_GetChunk
UNIVERSAL=Mix_CloseAudio
$ENDIF
$!
$!
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Now you can type @BUILD "
$!
$EXIT:
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$DEL TEST.OBJ;*
$DEL TEST.C;*
$DEL TEST.EXE;*
$DEAS SYS$ERROR
$DEAS SYS$OUTPUT
