$! (c) Alexey Chupahin  12-NOV-2007
$! GNU
$!
$!
$ SET NOON
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Configuring PRBOOM"
$WRITE SYS$OUTPUT "(c) Alexey Chupahin (aka CHAPG) "
$WRITE SYS$OUTPUT " "
$! Checking architecture
$DECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$    IF F$GETSYI("ARCH_TYPE").EQ.1 THEN CPU = "VAX"
$    IF F$GETSYI("ARCH_TYPE").EQ.2 THEN CPU = "Alpha"
$    IF F$GETSYI("ARCH_TYPE").EQ.3 THEN CPU = "I64"
$    OS = F$GETSYI("VERSION")
$WRITE SYS$OUTPUT "Checking architecture   ...  ", CPU
$WRITE SYS$OUTPUT "Checking OS             ...  OpenVMS ",OS
$SHARED=0
$IF ( (CPU.EQS."Alpha").OR.(CPU.EQS."I64") )
$  THEN
$       SHARED=64
$  ELSE
$       SHARED=32
$ENDIF
$!
$IF (DECC) THEN $WRITE SYS$OUTPUT  "Compiler		...  DEC C"
$IF (.NOT. DECC) THEN $WRITE SYS$OUTPUT  "BAD compiler" GOTO EXIT
$MMS = F$SEARCH("SYS$SYSTEM:MMS.EXE") .NES. ""
$MMK = F$TYPE(MMK) 
$IF (MMS .OR. MMK.NES."") THEN GOTO TEST_LIBRARIES
$! I cant find any make tool
$GOTO EXIT
$!
$!
$TEST_LIBRARIES:
$!   Setting as MAKE utility one of MMS or MMK. I prefer MMS.
$IF (MMK.NES."") THEN MAKE="MMK"
$IF (MMS) THEN MAKE="MMS"
$WRITE SYS$OUTPUT "Checking build utility	...  ''MAKE'"
$WRITE SYS$OUTPUT " "
$!
$!
$IF (P1.EQS."opengl").OR.(P1.EQS."OPENGL") 
$ THEN 
$	HAVE_OPENGL=1 
$ ELSE 
$ 	HAVE_OPENGL=0
$ENDIF
$IF HAVE_OPENGL.EQ.1
$ THEN
$	WRITE SYS$OUTPUT "Build with OpenGL support"
$ENDIF
$!"Checking for correct SDL library"
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ LIBSDL_STATIC=0
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ/INCLUDE=(SDL) SYS$INPUT
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>

int main(int argc, char *argv[])
{
        SDL_version compiled;

        /* Initialize SDL */
        if ( SDL_Init(0) < 0 ) {
                fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());                exit(2);
        }
#ifdef DEBUG
        fprintf(stderr, "SDL initialized\n");
#endif

#if SDL_VERSION_ATLEAST(1, 2, 14)
#else
        printf("checking version libSDL  : %d.%d.%d\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch);
        printf("libSDL is too old. Please get newest\n");
        printf("From http://fafner.dyndns.org/~alexey/libsdl/public.html\n");
	exit(2);
#endif
        printf("checking version libSDL  : %d.%d.%d\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch);
        SDL_Quit();
        return(0);
}

$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_LIBSDL=0
$       GOTO NEXT0
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,LIBSDL:LIBSDL$SHR/OPT
$TMP = $STATUS
$IF (TMP .NE. %X10000001.and. tmp .ne. %X10648268 )
$  THEN
$       LINK/EXE=TEST TEST,LIBSDL:LIBSDL/OPT
$       TMP = $STATUS
$       IF (TMP .NE. %X10000001)
$         THEN
$               TMP = $STATUS
$               HAVE_LIBSDL=0
$               GOTO NEXT0
$         ELSE
$               LIBSDL_STATIC=1
$       ENDIF
$ENDIF
$!
$DEAS  SYS$OUTPUT
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$       HAVE_LIBSDL=0
$	GOTO NEXT0
$  ELSE
$        HAVE_LIBSDL=1
$ENDIF
$DEAS  SYS$ERROR
$NEXT0:
$IF (HAVE_LIBSDL.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   No"
$	GOTO EXIT
$ENDIF
$!
$!"Checking for TCPIP Services ... "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ SYS$INPUT
	#include  <netinet/in.h>
	#include  <netinet/tcp.h>
	#include  <sys/socket.h>

    int main()
	{
	}
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_TCPIP=0
$       GOTO NEXT1
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST
$TMP = $STATUS
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_TCPIP=0
$       GOTO NEXT1
$ENDIF
$!
$DEFINE SYS$ERROR _NLA0:
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$	HAVE_TCPIP=0
$  ELSE
$	 HAVE_TCPIP=1
$ENDIF
$DEAS  SYS$ERROR
$NEXT1:
$IF (HAVE_TCPIP.EQ.1)
$  THEN
$ 	WRITE SYS$OUTPUT "Checking for TCPIP ...   Yes"	
$  ELSE
$	WRITE SYS$OUTPUT "Checking for TCPIP ...   No"
$ENDIF
$!
$GOTO MIXER
$!Do not check LIBSDL_NET
$!
$!Checking LIBSDL_NET
$!
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ LIBSDL_IMAGE_STATIC=0
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ/INCLUDE=(SDL,LIBSDL_NET) SYS$INPUT
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>
#include <sdl_net.h>

int main(int argc, char *argv[])
{
        SDL_version compiled;

        /* Initialize SDL */
        if ( SDL_Init(0) < 0 ) {
        }
#ifdef DEBUG
        fprintf(stderr, "SDL initialized\n");
#endif                                                 
        SDL_NET_VERSION(&compiled);                  
        if ( (compiled.major>=1) && (compiled.minor>=2) )
        {                                              
                printf("checking version LIBSDL_NET  : %d.%d.%d\n",
                compiled.major,                        
                compiled.minor,
                compiled.patch);                       
                SDL_Quit();
                return(0);                             
                exit(0);
        }                                              
        else
        {                                              
                printf("checking version LIBSDL_NET  : %d.%d.%d\n",
                compiled.major,                        
                compiled.minor,
                compiled.patch);                       
                printf("This version is not valid. Please get good one\n");
                printf("From http://fafner.dyndns.org/~alexey/libsdl/public.html\n");
                exit(2);                               
        }                                              
}
                                                       
$TMP = $STATUS
$DEASS SYS$ERROR                                       
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)                              
$  THEN
$       HAVE_LIBSDL_NET=0                            
$       GOTO NEXT2
$ENDIF                                                 
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:                              
$LINK/EXE=TEST TEST,LIBSDL_NET:LIBSDL_NET$SHR/OPT,LIBSDL:LIBSDL$SHR/OPT
$TMP = $STATUS                                         
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001.and. tmp .ne. %X10648268 )                              
$  THEN
$       LINK/EXE=TEST TEST,LIBSDL_NET:LIBSDL_NET/OPT,LIBSDL:LIBSDL/OPT
$       TMP = $STATUS
$       IF (TMP .NE. %X10000001)                       
$         THEN
$               GOTO NEXT2                             
$         ELSE
$               LIBSDL_NET_STATIC=1                  
$       ENDIF
$ENDIF                                                 
$!
$RUN TEST                                              
$IF ($STATUS .NE. %X00000001)
$  THEN                                                
$       HAVE_LIBSDL_NET=0
$       GOTO NEXT2                                     
$  ELSE
$        HAVE_LIBSDL_NET=1                           
$ENDIF
$DEAS  SYS$ERROR                                       
$NEXT2:
$IF (HAVE_LIBSDL_NET.EQ.1)                           
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct LIBSDL_NET ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct LIBSDL_NET ...   No"
$       WRITE SYS$OUTPUT "This is fatal. Please install LIBSDL_NET from http://fafner.dyndns.org/~alexey/libsdl/public.html"
$       GOTO EXIT                                      
$ENDIF
$!                                                     
$!
$!checking LIBSDL_MIXER
$!
$MIXER:
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ LIBSDL_MIXER_STATIC=0
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ/INCLUDE=(SDL,LIBSDL_MIXER) SYS$INPUT
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>
#include <sdl_mixer.h>

int main(int argc, char *argv[])
{
        SDL_version compiled;                          

        /* Initialize SDL */                           
        if ( SDL_Init(0) < 0 ) {
        }
#ifdef DEBUG                                           
        fprintf(stderr, "SDL initialized\n");
#endif                                                 
        SDL_MIXER_VERSION(&compiled);
        if ( (compiled.major>=1) && (compiled.minor>=2) )
        {
                printf("checking version LIBSDL_MIXER  : %d.%d.%d\n",
                compiled.major,
                compiled.minor,                        
                compiled.patch);
                SDL_Quit();                            
                return(0);
                exit(0);                               
        }
        else                                           
        {
                printf("checking version LIBSDL_MIXER  : %d.%d.%d\n",
                compiled.major,
                compiled.minor,                        
                compiled.patch);
                printf("This version is not valid. Please get good one\n");
                printf("From http://fafner.dyndns.org/~alexey/libsdl/public.html\n");
                exit(2);                               
        }
}                                                      

$TMP = $STATUS                                         
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT                                      
$IF (TMP .NE. %X10B90001)
$  THEN                                                
$       HAVE_LIBSDL_MIXER=0
$       GOTO NEXT3                                     
$ENDIF
$DEFINE SYS$ERROR _NLA0:                               
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,LIBSDL_MIXER:LIBSDL_MIXER$SHR/OPT,LIBSDL:LIBSDL$SHR/OPT
$TMP = $STATUS
$DEAS  SYS$OUTPUT                                      
$IF (TMP .NE. %X10000001 .and. tmp .ne. %X10648268 )
$  THEN                                                
$       LINK/EXE=TEST TEST,LIBSDL_MIXER:LIBSDL_MIXER/OPT,LIBSDL:LIBSDL/OPT
$       TMP = $STATUS                                  
$       IF (TMP .NE. %X10000001 .and. tmp .ne. %X10648268 )
$         THEN                                         
$               GOTO NEXT3
$         ELSE                                         
$               LIBSDL_MIXER_STATIC=1
$       ENDIF                                          
$ENDIF
$!                                                     
$RUN TEST
$IF ($STATUS .NE. %X00000001)                          
$  THEN
$       HAVE_LIBSDL_MIXER=0                            
$       GOTO NEXT3
$  ELSE                                                
$        HAVE_LIBSDL_MIXER=1
$ENDIF                                                 
$DEAS  SYS$ERROR
$NEXT3:                                                
$IF (HAVE_LIBSDL_MIXER.EQ.1)
$  THEN                                                
$       WRITE SYS$OUTPUT "Checking for correct LIBSDL_MIXER ...   Yes"
$  ELSE                                                
$       WRITE SYS$OUTPUT "Checking for correct LIBSDL_MIXER ...   No"
$       GOTO EXIT
$ENDIF                                                 
$!
$!
$!
$! Checking vsnprintf
$!
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ SYS$INPUT
   #include <stdio.h>
   #include <stdlib.h>
   #include <varargs.h>
   int main()
     {
        char *s=malloc(12);                            
        int  i = vsnprintf(s,(size_t)11,"",(va_list) NULL);
	free(s);
     }
$!                                                     
$TMP = $STATUS
$DEASS SYS$ERROR                                       
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP                                 
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_VSNPRINTF=0                               
$       GOTO NEXT5                                     
$ENDIF
$DEFINE SYS$ERROR _NLA0:                               
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST                                    
$TMP = $STATUS
$DEAS  SYS$ERROR                                       
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP                                 
$IF (TMP .NE. %X10000001)
$  THEN                                                
$       HAVE_VSNPRINTF=0                               
$       GOTO NEXT5                                     
$  ELSE                                                
$       HAVE_VSNPRINTF=1                               
$ENDIF                                                 
$NEXT5:                                                
$IF (HAVE_VSNPRINTF.EQ.1)                              
$  THEN                                                
$       WRITE SYS$OUTPUT "Checking for vsnprintf ...   Yes"
$  ELSE                                                
$       WRITE SYS$OUTPUT "Checking for vsnprintf ...   No"
$ENDIF                                                 
$!
$!                                                     
$!
$WRITE SYS$OUTPUT "Generating CONFIG.H"
COPY SYS$INPUT CONFIG.H
/* Define for support for MBF helper dogs */
#define DOGS 1

/* Define to be the path where Doom WADs are stored */
#define DOOMWADDIR "doom_wad/"


/* Define to 1 if you have the <asm/byteorder.h> header file. */
//#define HAVE_ASM_BYTEORDER_H 1

/* Define to 1 if you have the declaration of `sys_siglist', and to 0 if you
   don't. */
//#define HAVE_DECL_SYS_SIGLIST 1

/* Define to 1 if you have the `getopt' function. */
#define HAVE_GETOPT 1

/* Define to 1 if you have the `inet_aton' function. */
#define HAVE_INET_ATON 1

/* Define to 1 if you have the `inet_ntop' function. */
//#define HAVE_INET_NTOP 1

/* Define to 1 if you have the `inet_pton' function. */
//#define HAVE_INET_PTON 1

/* Define to 1 if you have the <inttypes.h> header file. */
#define HAVE_INTTYPES_H 1

/* Define if you have struct sockaddr_in6 */
//#define HAVE_IPv6 1

/* Define to 1 if you have the `m' library (-lm). */
#define HAVE_LIBM 1


/* Define to 1 if you have the `SDL_mixer' library (-lSDL_mixer). */
#define HAVE_LIBSDL_MIXER 1

/* Define if you have the SDL net library -lSDL_net */
//#define HAVE_LIBSDL_NET 1

/* Define to 1 if you have the <memory.h> header file. */
#define HAVE_MEMORY_H 1

/* Define to 1 if you have the `mmap' function. */
//#define HAVE_MMAP 1

/* Define if you want network game support */
//#define HAVE_NET

/* Define to 1 if you have the <sched.h> header file. */
//#define HAVE_SCHED_H 1

/* Define to 1 if you have the `sched_setaffinity' function. */
//#define HAVE_SCHED_SETAFFINITY 1

/* Define to 1 if you have the `SDL_JoystickGetAxis' function. */
//#define HAVE_SDL_JOYSTICKGETAXIS 1

/* Define to 1 if you have the `snprintf' function. */
#define HAVE_SNPRINTF 1

/* Define to 1 if you have the <stdint.h> header file. */
//#define HAVE_STDINT_H 1

/* Define to 1 if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H 1

/* Define to 1 if you have the <strings.h> header file. */
#define HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
#define HAVE_STRING_H 1

/* Define to 1 if you have the <sys/stat.h> header file. */
#define HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/types.h> header file. */
#define HAVE_SYS_TYPES_H 1

/* Define to 1 if you have <sys/wait.h> that is POSIX.1 compatible. */
#define HAVE_SYS_WAIT_H 1

/* Define to 1 if you have the <unistd.h> header file. */
#define HAVE_UNISTD_H 1

/* Define to 1 if you have the `usleep' function. */
#define HAVE_USLEEP 1

/* Define to 1 if you have the `vsnprintf' function. */
#define HAVE_VSNPRINTF 1

/* Uncomment this to cause heap dumps to be generated. Only useful if
   INSTRUMENTED is also defined. */
/* #undef HEAPDUMP */

/* Define for high resolution support */
#define HIGHRES 1

/* Define on targets supporting 386 assembly */
//#define I386_ASM 1

/* Define this to see real-time memory allocation statistics, and enable extra
   debugging features */
/* #undef INSTRUMENTED */

/* If your platform has a fast version of max, define MAX to it */
/* #undef MAX */

/* If your platform has a fast version of min, define MIN to it */
/* #undef MIN */

/* Name of package */
#define PACKAGE "prboom"

/* Define to the address where bug reports for this package should be sent. */
#define PACKAGE_BUGREPORT ""

/* Define to the full name of this package. */
#define PACKAGE_NAME "prboom"

/* Define to the full name and version of this package. */
#define PACKAGE_STRING "prboom 2.5.0 VMS"

/* Define to the one symbol short name of this package. */
#define PACKAGE_TARNAME "prboom"

/* Define to the version of this package. */
#define PACKAGE_VERSION "2.5.0"

/* Set to the attribute to apply to struct definitions to make them packed */
#define PACKEDATTR __attribute__((packed))

/* Define to enable internal range checking */
/* #undef RANGECHECK */

/* Define if you have an old SDL_net, such that the UDPpacket structure has a
   src member instead of an address member */
/* #undef SDL_NET_UDP_PACKET_SRC */

/* When defined this causes quick checks which only impose significant
   overhead if a posible error is detected. */
#define SIMPLECHECKS 1

/* Define to 1 if you have the ANSI C header files. */
#define STDC_HEADERS 1

/* Defining this causes time stamps to be created each time a lump is locked,
   and lumps locked for long periods of time are reported */
/* #undef TIMEDIAG */

/* Define if you want to use gluImageScale */
//#define USE_GLU_IMAGESCALE 1

/* Define if you want to use gluBuild2DMipmaps */
//#define USE_GLU_MIPMAP 1

/* Define if you want to use the SDL net lib */
/* #undef USE_SDL_NET */

/* Version number of package */
#define VERSION "2.5.0"

/* Define if using the dmalloc debugging malloc package */
/* #undef WITH_DMALLOC */

/* Define to 1 if your processor stores words with the most significant byte
   first (like Motorola and SPARC, unlike Intel and VAX). */
/* #undef WORDS_BIGENDIAN */

/* Define this to perform id checks on zone blocks, to detect corrupted and
   illegally freed blocks */
#define ZONEIDCHECK 1

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef const */

/* Define to `int' if <sys/types.h> doesn't define. */
/* #undef gid_t */

/* Define to `__inline__' or `__inline' if that's what the C compiler
   calls it, or to nothing if 'inline' is not supported under any name.  */
#ifndef __cplusplus
/* #undef inline */
#endif

/* Define to `unsigned int' if <sys/types.h> does not define. */
/* #undef size_t */

/* Define to strcasecmp, if we have it */
#define stricmp strcasecmp

/* Define to strncasecmp, if we have it */
#define strnicmp strncasecmp

/* Define to `int' if <sys/types.h> doesn't define. */
/* #undef uid_t */

$IF HAVE_OPENGL.EQ.1
$ THEN
$       APP SYS$INPUT CONFIG.H
#define GL_DOOM 1
$ENDIF
$IF HAVE_VSNPRINTF.EQ.1
$ THEN
$	APP SYS$INPUT CONFIG.H
#define HAVE_SNPRINTF 1

#define HAVE_VSNPRINTF 1
$ENDIF
$!
$!
$WRITE SYS$OUTPUT "Generating DESCRIP.MMS"
$COPY SYS$INPUT [.SRC]DESCRIP.MMS
# (c) Alexey Chupahin 12-AUG-2010
# OpenVMS 7.3-2, DEC 2000 mod.300
# OpenVMS 8.3,   Compaq DS10L
# OpenVMS 8.3,   HP rx1620
C=cc

CFLAGS = /INCLUDE=([-],[], X11, SDL, LIBSDL_NET, LIBSDL_MIXER ) /DEFINE=(HAVE_CONFIG_H) \
	 /OPT=(INLINE=SPEED) /NOMEMBER /FLOAT=IEEE/name=(as_is,short)

OBJ=\
am_map.obj,\
doomdef.obj,\
doomstat.obj,\
dstrings.obj,\
d_client.obj,\
d_deh.obj,\
d_items.obj,\
d_main.obj,\
f_finale.obj,\
f_wipe.obj,\
g_game.obj,\
$IF HAVE_OPENGL.EQ.1
$ THEN
$	APP SYS$INPUT [.SRC]DESCRIP.MMS
gl_main.obj,\
gl_texture.obj,\
$ENDIF
$APP SYS$INPUT [.SRC]DESCRIP.MMS
hu_lib.obj,\
hu_stuff.obj,\
info.obj,\
lprintf.obj,\
m_argv.obj,\
m_bbox.obj,\
m_cheat.obj,\
m_menu.obj,\
m_misc.obj,\
m_random.obj,\
mmus2mid.obj,\
md5.obj,\
p_ceilng.obj,\
p_doors.obj,\
p_checksum.obj,\
p_enemy.obj,\
p_floor.obj,\
p_genlin.obj,\
p_inter.obj,\
p_lights.obj,\
p_map.obj,\
p_maputl.obj,\
p_mobj.obj,\
p_plats.obj,\
p_pspr.obj,\
p_saveg.obj,\
p_setup.obj,\
p_sight.obj,\
p_spec.obj,\
p_switch.obj,\
p_telept.obj,\
p_tick.obj,\
p_user.obj,\
r_bsp.obj,\
r_fps.obj,\
r_filter.obj,\
r_data.obj,\
r_draw.obj,\
r_demo.obj,\
r_main.obj,\
r_plane.obj,\
r_patch.obj,\
r_segs.obj,\
r_sky.obj,\
r_things.obj,\
sounds.obj,\
st_lib.obj,\
st_stuff.obj,\
s_sound.obj,\
tables.obj,\
version.obj,\
v_video.obj,\
wi_stuff.obj,\
w_wad.obj,\
w_mmap.obj,\
z_bmalloc.obj,\
z_zone.obj,\
[.SDL]i_main.obj,\
[.SDL]i_joy.obj,\
[.SDL]i_sound.obj,\
[.SDL]i_sshot.obj,\
[.SDL]i_system.obj,\
[.SDL]i_video.obj

ALL : DOOM.EXE
        $!


DOOM.OLB : $(OBJ)
        LIB/CREA DOOM.OLB $(OBJ)

am_map.obj : am_map.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

doomdef.obj : doomdef.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

doomstat.obj : doomstat.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

dstrings.obj : dstrings.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

d_client.obj : d_client.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

d_deh.obj : d_deh.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

d_items.obj : d_items.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.SDL]i_sshot.obj : [.SDL]i_sshot.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

d_main.obj : d_main.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

d_server.obj : d_server.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

f_finale.obj : f_finale.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

f_wipe.obj : f_wipe.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

gl_main.obj : gl_main.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

gl_texture.obj : gl_texture.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

g_game.obj : g_game.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

hu_lib.obj : hu_lib.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

hu_stuff.obj : hu_stuff.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

info.obj : info.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.SDL]i_main.obj : [.SDL]i_main.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

i_udp_sdl.obj : i_udp_sdl.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

lprintf.obj : lprintf.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mmus2mid.obj : mmus2mid.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

m_argv.obj : m_argv.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

m_bbox.obj : m_bbox.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

m_cheat.obj : m_cheat.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

m_menu.obj : m_menu.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

md5.obj : md5.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

m_misc.obj : m_misc.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

m_random.obj : m_random.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_ceilng.obj : p_ceilng.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_doors.obj : p_doors.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_enemy.obj : p_enemy.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_floor.obj : p_floor.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_genlin.obj : p_genlin.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_inter.obj : p_inter.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_lights.obj : p_lights.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_map.obj : p_map.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_maputl.obj : p_maputl.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_mobj.obj : p_mobj.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_plats.obj : p_plats.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_checksum.obj : p_checksum.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_patch.obj : p_patch.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_pspr.obj : p_pspr.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_saveg.obj : p_saveg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_setup.obj : p_setup.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_sight.obj : p_sight.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_spec.obj : p_spec.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_switch.obj : p_switch.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_telept.obj : p_telept.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_tick.obj : p_tick.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_user.obj : p_user.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_bsp.obj : r_bsp.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_data.obj : r_data.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_draw.obj : r_draw.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_demo.obj : r_demo.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_main.obj : r_main.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_patch.obj : r_patch.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_plane.obj : r_plane.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_segs.obj : r_segs.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_filter.obj : r_filter.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_fps.obj : r_fps.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_sky.obj : r_sky.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_things.obj : r_things.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sounds.obj : sounds.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

st_lib.obj : st_lib.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

st_stuff.obj : st_stuff.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

s_sound.obj : s_sound.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tables.obj : tables.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

version.obj : version.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

v_video.obj : v_video.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

wi_stuff.obj : wi_stuff.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

w_wad.obj : w_wad.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

w_mmap.obj : w_mmap.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

z_bmalloc.obj : z_bmalloc.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

z_zone.obj : z_zone.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.SDL]i_joy.obj : [.SDL]i_joy.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.SDL]i_sound.obj : [.SDL]i_sound.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.SDL]i_system.obj : [.SDL]i_system.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

[.SDL]i_video.obj : [.SDL]i_video.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

$IF LIBSDL_STATIC.EQ.1
$ THEN
$	APP SYS$INPUT  [.SRC]DESCRIP.MMS
DOOM.EXE : DOOM.OLB
        LINK/EXE=DOOM.EXE [.SDL]I_MAIN,[]DOOM/LIB,libsdl_mixer:libsdl_mixer/opt,libsdl:libsdl/opt
$ ELSE
$	APP SYS$INPUT  [.SRC]DESCRIP.MMS
DOOM.EXE : DOOM.OLB
        LINK/EXE=DOOM.EXE [.SDL]I_MAIN,[]DOOM/LIB,libsdl:libsdl$shr/opt,libsdl_mixer:libsdl_mixer/opt
$ENDIF
$!
$! 
$WRITE SYS$OUTPUT "Generating BUILD.COM "
$OPEN/WRITE OUT BUILD.COM
$IF HAVE_OPENGL.EQ.1 THEN WRITE OUT "$DEF GL SYS$COMMON:[DECW$INCLUDE.GL_1_2]"
$WRITE OUT "$SET DEF [.SRC]"
$WRITE OUT "$",MAKE,"/IGN=WAR"
$WRITE OUT "$SET DEF [-]"
$CLOSE OUT
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Now you can type @BUILD "
$!
$EXIT:
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$DEL TEST.OBJ;*
$DEL TEST.C;*
$DEL TEST.EXE;*
$DEAS SYS$ERROR
$DEAS SYS$OUTPUT
