$! Configure procedure 
$! (c) Alexey Chupahin  12-JUL-2006
$! 
$! SHARED=64 - creating shared libtiff for Alpha and (may be IA64)
$! SHARED=32 - creating shared libtiff for VAX 
$! 
$!
$ SET NOON
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Configuring LIBSDL library"
$WRITE SYS$OUTPUT "(c) Alexey Chupahin"
$WRITE SYS$OUTPUT "alexey@vaxman.de"
$WRITE SYS$OUTPUT "Rostov-on-Don, Russia"
$WRITE SYS$OUTPUT " "
$IF P1.EQS."HELP"
$ THEN
$	WRITE SYS$OUTPUT "@CONFIGURE [OPENGL]"
$	EXIT
$ENDIF
$OPENGL=0
$IF (P1.EQS."opengl") .OR. (P1.EQS."OPENGL") THEN OPENGL=1 
$! Checking architecture
$DECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$    IF F$GETSYI("ARCH_TYPE").EQ.1 THEN CPU = "VAX"
$    IF F$GETSYI("ARCH_TYPE").EQ.2 THEN CPU = "Alpha"
$    IF F$GETSYI("ARCH_TYPE").EQ.3 THEN CPU = "I64"
$WRITE SYS$OUTPUT "Checking architecture 	...  ", CPU
$SHARED=0
$IF ( (CPU.EQS."Alpha").OR.(CPU.EQS."I64") )
$  THEN 
$	SHARED=64
$  ELSE
$	SHARED=32
$ENDIF
$IF (DECC) THEN $WRITE SYS$OUTPUT  "Compiler		...  DEC C"
$IF (.NOT. DECC) THEN $WRITE SYS$OUTPUT  "BAD compiler" GOTO EXIT
$MMS = F$SEARCH("SYS$SYSTEM:MMS.EXE") .NES. ""
$MMK = F$TYPE(MMK) 
$IF (MMS .OR. MMK.NES."") THEN GOTO TEST_LIBRARIES
$! I cant find any make tool
$ WRITE SYS$OUTPUT "Install MMS or MMK"
$GOTO EXIT
$!
$!
$TEST_LIBRARIES:
$!   Setting as MAKE utility one of MMS or MMK. I prefer MMS.
$IF (MMK.NES."") THEN MAKE="MMK"
$IF (MMS) THEN MAKE="MMS"
$WRITE SYS$OUTPUT "Checking build utility	...  ''MAKE'"
$WRITE SYS$OUTPUT " "
$!
$!
$!"Checking for getenv "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ SYS$INPUT
	#include  <stdlib.h>

    int main()
	{
	   char *s;
	   s=getenv("LIBSDL");
	}
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_GETENV=0
$       GOTO NEXT1
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST
$TMP = $STATUS
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_GETENV=0
$       GOTO NEXT1
$ENDIF
$!
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$	HAVE_GETENV=0
$  ELSE
$	 HAVE_GETENV=1
$ENDIF
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$NEXT1:
$IF (HAVE_GETENV.EQ.1)
$  THEN
$ 	WRITE SYS$OUTPUT "Checking for getenv ...   Yes"	
$  ELSE
$	WRITE SYS$OUTPUT "Checking for getenv ...   No"
$ENDIF
$!
$!

$!"Checking for iconv "
$       HAVE_ICONV=0
$!
$!"Checking for nanosleep    "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ/INCLUDE=(ZLIB) SYS$INPUT
      #include <time.h>
   int main()
     {
	int i=nanosleep ((struct timespec*) NULL, (struct timespec*) NULL);
     }
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001) 
$  THEN 
$	HAVE_NANOSLEEP=0
$	GOTO NEXT3
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST 
$TMP = $STATUS
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001) 
$  THEN 
$	HAVE_NANOSLEEP=0
$       GOTO NEXT3
$  ELSE
$	HAVE_NANOSLEEP=1
$ENDIF
$NEXT3:
$IF (HAVE_NANOSLEEP.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for nanosleep ...   Yes"
$  ELSE
$	WRITE SYS$OUTPUT "Checking for nanosleep ...   No"
$ENDIF
$!
$!
$!
$!"Checking for snprintf    "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ SYS$INPUT
   #include <stdio.h>
   #include <stdlib.h>
   int main()
     {
	char *s=malloc(12);
	int  i = snprintf(s,(size_t)11,"%s","Hello mudo");
     }
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_SNPRINTF=0
$       GOTO NEXT4
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST
$TMP = $STATUS
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_SNPRINTF=0
$       GOTO NEXT4
$  ELSE
$       HAVE_SNPRINTF=1
$ENDIF
$NEXT4:
$IF (HAVE_SNPRINTF.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for snprintf ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for snprintf ...   No"
$ENDIF
$!
$!
$!
$!"Checking for vsnprintf    "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ SYS$INPUT
   #include <stdio.h>
   #include <stdlib.h>
   #include <varargs.h>
   int main()
     {
        char *s=malloc(12);
        int  i = vsnprintf(s,(size_t)11,(char*) NULL, (va_list) NULL);
     }
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_VSNPRINTF=0
$       GOTO NEXT5
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST
$TMP = $STATUS
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_VSNPRINTF=0
$       GOTO NEXT5
$  ELSE
$       HAVE_VSNPRINTF=1
$ENDIF
$NEXT5:
$IF (HAVE_VSNPRINTF.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for vsnprintf ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for vsnprintf ...   No"
$ENDIF
$!
$!"Checking for stdint.h    "
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ SYS$INPUT
   #include <stdint.h>
   int main()
     {
     }
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_STDINT_H=0
$  ELSE
$	HAVE_STDINT_H=1
$ENDIF
$IF (HAVE_STDINT_H.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for stdint.h ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for stdint.h ...   No"
$ENDIF
$!
$!
$! Checking for X11 ...
$IF F$TRNLNM("DECW$INCLUDE") .NES. ""
$  THEN
$	WRITE SYS$OUTPUT "Checking for X11 ...   Yes"
$  ELSE
$	WRITE SYS$OUTPUT "Checking for X11 ...   No"
$	WRITE SYS$OUTPUT "This is fatal. Please install X11 software"
$	GOTO EXIT
$ENDIF
$!
$!Checking for multimedia
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ DEFINE MME MMOV$INCLUDE
$ CC/OBJECT=TEST.OBJ/INC=MME SYS$INPUT
   #include <stdio.h>
   #include <mme/mme_api.h>
   int main()
     {
	printf ("Audio devices detected: 	%d\n",waveOutGetNumDevs());
     }
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$MMOV_SHARED=0
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_MMOV=0
$	GOTO NEXT6
$ENDIF
$OPEN/WRI OUT []TEST.OPT
$WRITE OUT "SYS$LIBRARY:MMOV/LIB"
$WRITE OUT "SYS$SHARE:CMA$OPEN_RTL.EXE/SHARE"
$WRITE OUT "SYS$SHARE:IPC$SHARE.EXE/SHARE"
$CLOSE OUT
$LINK/EXE=TEST []TEST,TEST/OPT
$TMP = $STATUS
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_MMOV=0
$       GOTO NEXT6
$  ELSE
$       HAVE_MMOV=1
$ENDIF
$!checking for shared MMOV
$OPEN/WRI OUT TEST.OPT
$WRITE OUT "SYS$SHARE:MMOV/SHARE"
$CLOSE OUT
$LINK/EXE=TEST TEST,TEST/OPT
$TMP = $STATUS
$!DEAS  SYS$ERROR
$!DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .Eq. %X10000001 .or. tmp .eq. %X10648268 )
$  THEN
$       MMOV_SHARED=1
$       GOTO NEXT6
$  ELSE
$       MMOV_SHARED=0
$ENDIF
$NEXT6:
$IF (HAVE_MMOV.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for OpenVMS Multimedia  ...   Yes"
$	RU TEST
$	DEL TEST.OPT;*
$	IF (MMOV_SHARED.EQ.1)
$	   THEN
$		WRITE SYS$OUTPUT "Shared Multimedia library...   Yes"
$	   ELSE
$		WRITE SYS$OUTPUT "Shared Multimedia library...   No"
$		WRITE SYS$OUTPUT "**** Shared library will be created during BUILD process ****"
$		WRITE SYS$OUTPUT "**** You should have rights to write into SYS$SHARE:     ****"
$	ENDIF
$  ELSE
$       WRITE SYS$OUTPUT "Checking for OpenVMS Multimedia  ...   No"
$ENDIF
$!
$! Checking for OpenGL
$!
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$!DEF GL SYS$COMMON:[DECW$INCLUDE.GL_1_2]
$CC/float=ieee/name=(as_is,short)/OBJECT=TEST.OBJ/INC=MME SYS$INPUT
   #include <stdio.h>
   #include <stdlib.h>
   #include <GL/glx.h>
   int main()
     {
   char *displayName = NULL;
   Display *dpy;
   Window win;
   Bool allowDirect=1;
   int attribSingle[] = {
      GLX_RGBA,
      GLX_RED_SIZE, 1,
      GLX_GREEN_SIZE, 1,
      GLX_BLUE_SIZE, 1,
      None };
   int attribDouble[] = {
      GLX_RGBA,
      GLX_RED_SIZE, 1,
      GLX_GREEN_SIZE, 1,
      GLX_BLUE_SIZE, 1,
      GLX_DOUBLEBUFFER,
      None };

   XSetWindowAttributes attr;
   unsigned long mask;
   Window root;
   GLXContext ctx = NULL;
   XVisualInfo *visinfo;
   int width = 100, height = 100;
   int scrnum=0;

      dpy = XOpenDisplay(displayName);
      if (!dpy) {
        printf("OpenGL Direct rendering:  No\n");
        exit(1);
      }
   root = RootWindow(dpy, scrnum);

   visinfo = glXChooseVisual(dpy, scrnum, attribSingle);
   if (!visinfo)
      visinfo = glXChooseVisual(dpy, scrnum, attribDouble);

   if (visinfo)
      ctx = glXCreateContext( dpy, visinfo, NULL, allowDirect );


	if (glXIsDirect(dpy, ctx)) {
        printf("OpenGL Direct rendering...   Yes\n");
	}
	else
	{
        printf("OpenGL Direct rendering...   No\n");
        exit(1);
	}
   attr.background_pixel = 0;
   attr.border_pixel = 0;
   attr.colormap = XCreateColormap(dpy, root, visinfo->visual, AllocNone);
   attr.event_mask = StructureNotifyMask | ExposureMask;
  mask = CWBackPixel | CWBorderPixel | CWColormap | CWEventMask;
  win = XCreateWindow(dpy, root, 0, 0, width, height,
                       0, visinfo->depth, InputOutput,
                       visinfo->visual, mask, &attr);
     
   if (glXMakeCurrent(dpy, win, ctx)) {
      const char *serverVendor = glXQueryServerString(dpy, scrnum, GLX_VENDOR);
      const char *serverVersion = glXQueryServerString(dpy, scrnum, GLX_VERSION);
      const char *serverExtensions = glXQueryServerString(dpy, scrnum, GLX_EXTENSIONS);
      const char *clientVendor = glXGetClientString(dpy, GLX_VENDOR);
      const char *clientVersion = glXGetClientString(dpy, GLX_VERSION);
      const char *clientExtensions = glXGetClientString(dpy, GLX_EXTENSIONS);
      const char *glxExtensions = glXQueryExtensionsString(dpy, scrnum);
      const char *glVendor = (const char *) glGetString(GL_VENDOR);
      const char *glRenderer = (const char *) glGetString(GL_RENDERER);
      const char *glVersion = (const char *) glGetString(GL_VERSION);
      const char *glExtensions = (const char *) glGetString(GL_EXTENSIONS);
      int glxVersionMajor;
      int glxVersionMinor;
      char *displayName = NULL;
      char *colon = NULL, *period = NULL;
	printf("\tServer:\t\t%s V%s \n",serverVendor,serverVersion);
	printf("\tRenderer:\t%s \n",glRenderer);
	printf("\tversion:\t%s \n",glVersion);
}
}
$!
$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_OPENGL=0
$       GOTO NEXT7
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$OPEN/WRI OUT []TEST.OPT
$!WRITE OUT "SYS$SHARE:DECW$MESA3DSHR_RADEON.EXE/SHARE"
$WRITE OUT "SYS$SHARE:libMesaGLU.exe/SHARE"
$WRITE OUT "SYS$SHARE:libMesaGL.exe/SHARE"
$WRITE OUT "Sys$Share:DECW$XMLibShr12.exe /Share"
$WRITE OUT "Sys$Share:DECW$XLibShr.exe /Share"
$CLOSE OUT
$LINK/EXE=TEST []TEST,TEST/OPT
$TMP = $STATUS
$!WRITE SYS$OUTPUT TMP
$DEAS  SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10000001)
$  THEN
$       HAVE_OPENGL=0
$       GOTO NEXT7
$  ELSE
$	RUN TEST
$	 IF ($STATUS .NE. %X00000001)
$	   THEN
$		HAVE_OPENGL=0
$	   ELSE
$       	HAVE_OPENGL=1
$	 ENDIF
$ENDIF
$!WRITE SYS$OUTPUT TMP
$NEXT7:
$IF (HAVE_OPENGL.EQ.1)
$ THEN
$		WRITE SYS$OUTPUT "OpenGL library support ...   Yes"
$ ELSE
$		WRITE SYS$OUTPUT "OpenGL library support ...   No"
$ENDIF
$!WRITING BUILD FILES
$!
$!
$NEXT8:
$COPY SYS$INPUT MMOV$DEF.OPT
symbol_vector = (ACMDRIVERADD	= PROCEDURE)
symbol_vector = (_ACMINITIALIZEDRIVERS	= PROCEDURE)
symbol_vector = (_ACMENABLED	= PROCEDURE)
symbol_vector = (_ACMGETWAVEMAPPERMEMORY	= PROCEDURE)
symbol_vector = (_ACMSENDMESSAGEPRIVATE	= PROCEDURE)
symbol_vector = (_ACMSENDMESSAGE	= PROCEDURE)
symbol_vector = (ACMSTREAMUNPREPAREHEADER	= PROCEDURE)
symbol_vector = (ACMSTREAMSIZE	= PROCEDURE)
symbol_vector = (ACMSTREAMRESET	= PROCEDURE)
symbol_vector = (ACMSTREAMPREPAREHEADER	= PROCEDURE)
symbol_vector = (ACMSTREAMOPEN	= PROCEDURE)
symbol_vector = (ACMSTREAMCONVERT	= PROCEDURE)
symbol_vector = (ACMSTREAMCLOSE	= PROCEDURE)
symbol_vector = (ACMMETRICS	= PROCEDURE)
symbol_vector = (ACMGETVERSION	= PROCEDURE)
symbol_vector = (ACMFORMATTAGENUM	= PROCEDURE)
symbol_vector = (ACMFORMATTAGDETAILS	= PROCEDURE)
symbol_vector = (ACMFORMATSUGGEST	= PROCEDURE)
symbol_vector = (ACMFORMATENUM	= PROCEDURE)
symbol_vector = (ACMFORMATDETAILS	= PROCEDURE)
symbol_vector = (ACMFORMATCHOOSE	= PROCEDURE)
symbol_vector = (ACMFILTERTAGENUM	= PROCEDURE)
symbol_vector = (ACMFILTERTAGDETAILS	= PROCEDURE)
symbol_vector = (ACMFILTERENUM	= PROCEDURE)
symbol_vector = (ACMFILTERDETAILS	= PROCEDURE)
symbol_vector = (ACMFILTERCHOOSE	= PROCEDURE)
symbol_vector = (ACMDRIVERREMOVE	= PROCEDURE)
symbol_vector = (ACMDRIVERPRIORITY	= PROCEDURE)
symbol_vector = (ACMDRIVEROPEN	= PROCEDURE)
symbol_vector = (ACMDRIVERMESSAGE	= PROCEDURE)
symbol_vector = (ACMDRIVERID	= PROCEDURE)
symbol_vector = (ACMDRIVERENUM	= PROCEDURE)
symbol_vector = (ACMDRIVERDETAILS	= PROCEDURE)
symbol_vector = (ACMDRIVERCLOSE	= PROCEDURE)
symbol_vector = (WMMEMBUFFERFREE	= PROCEDURE)
symbol_vector = (WMMEMBUFFERALLOC	= PROCEDURE)
symbol_vector = (WMMEMFREE	= PROCEDURE)
symbol_vector = (WMMEMALLOC	= PROCEDURE)
symbol_vector = (WMMEMUSERREMOVE	= PROCEDURE)
symbol_vector = (WMMEMUSERADD	= PROCEDURE)
symbol_vector = (WMACMRESET	= PROCEDURE)
symbol_vector = (WMACMWAVEINSTOP	= PROCEDURE)
symbol_vector = (WMACMADDBUFFER	= PROCEDURE)
symbol_vector = (WMACMOPEN	= PROCEDURE)
symbol_vector = (WMACMCLOSE	= PROCEDURE)
symbol_vector = (_WMACMPROCESSUSERCALLBACK	= PROCEDURE)
symbol_vector = (ADRIVER_IS_DRIVER_INSTALLED	= PROCEDURE)
symbol_vector = (ADRIVER_WDMESSAGE	= PROCEDURE)
symbol_vector = (ADRIVER_WODMESSAGE	= PROCEDURE)
symbol_vector = (ADRIVER_WIDMESSAGE	= PROCEDURE)
symbol_vector = (ADRIVER_FREE_BUFFER_MEMORY	= PROCEDURE)
symbol_vector = (ADRIVER_FREE_MEMORY	= PROCEDURE)
symbol_vector = (ADRIVER_GET_BUFFER_MEMORY	= PROCEDURE)
symbol_vector = (ADRIVER_GET_MEMORY	= PROCEDURE)
symbol_vector = (ADRIVER_GET_NUM_DEVICES	= PROCEDURE)
symbol_vector = (ADRIVER_IS_VALID_DEVICE_ID	= PROCEDURE)
symbol_vector = (ADRIVER_LOAD_DRIVER	= PROCEDURE)
symbol_vector = (ADRIVER_CLOSE_DRIVER	= PROCEDURE)
symbol_vector = (ADRIVER_CLASS_TO_DRIVER	= PROCEDURE)
symbol_vector = (_WAVEADDBUFFER	= PROCEDURE)
symbol_vector = (WAVEOUTWRITE	= PROCEDURE)
symbol_vector = (WAVEOUTUNPREPAREHEADER	= PROCEDURE)
symbol_vector = (WAVEOUTSETVOLUME	= PROCEDURE)
symbol_vector = (WAVEOUTSETPLAYBACKRATE	= PROCEDURE)
symbol_vector = (WAVEOUTSETPITCH	= PROCEDURE)
symbol_vector = (WAVEOUTSELECTPORTS	= PROCEDURE)
symbol_vector = (WAVEOUTRESTART	= PROCEDURE)
symbol_vector = (WAVEOUTRESET	= PROCEDURE)
symbol_vector = (WAVEOUTPREPAREHEADER	= PROCEDURE)
symbol_vector = (WAVEOUTPAUSE	= PROCEDURE)
symbol_vector = (_WAVEOPEN	= PROCEDURE)
symbol_vector = (WAVEOUTOPEN	= PROCEDURE)
symbol_vector = (WAVEOUTMESSAGE	= PROCEDURE)
symbol_vector = (WAVEOUTGETVOLUME	= PROCEDURE)
symbol_vector = (WAVEOUTGETPOSITION	= PROCEDURE)
symbol_vector = (WAVEOUTGETPORTS	= PROCEDURE)
symbol_vector = (WAVEOUTGETPLAYBACKRATE	= PROCEDURE)
symbol_vector = (WAVEOUTGETPITCH	= PROCEDURE)
symbol_vector = (WAVEOUTGETNUMDEVS	= PROCEDURE)
symbol_vector = (WAVEOUTGETID	= PROCEDURE)
symbol_vector = (WAVEOUTGETFORMATINFO	= PROCEDURE)
symbol_vector = (WAVEOUTGETERRORTEXTA	= PROCEDURE)
symbol_vector = (WAVEOUTGETDEVCAPSEXA	= PROCEDURE)
symbol_vector = (WAVEOUTGETDEVCAPSA	= PROCEDURE)
symbol_vector = (WAVEOUTFORMATDETAILS	= PROCEDURE)
symbol_vector = (WAVEOUTCLOSE	= PROCEDURE)
symbol_vector = (WAVEOUTBREAKLOOP	= PROCEDURE)
symbol_vector = (WAVEINUNPREPAREHEADER	= PROCEDURE)
symbol_vector = (WAVEINPREPAREHEADER	= PROCEDURE)
symbol_vector = (WAVEINSETVOLUME	= PROCEDURE)
symbol_vector = (WAVEINSTOP	= PROCEDURE)
symbol_vector = (WAVEINSTART	= PROCEDURE)
symbol_vector = (WAVEINRESET	= PROCEDURE)
symbol_vector = (WAVEINOPEN	= PROCEDURE)
symbol_vector = (WAVEINSELECTPORTS	= PROCEDURE)
symbol_vector = (WAVEINMESSAGE	= PROCEDURE)
symbol_vector = (WAVEINGETVOLUME	= PROCEDURE)
symbol_vector = (WAVEINGETPOSITION	= PROCEDURE)
symbol_vector = (WAVEINGETPORTS	= PROCEDURE)
symbol_vector = (WAVEINGETNUMDEVS	= PROCEDURE)
symbol_vector = (WAVEINGETID	= PROCEDURE)
symbol_vector = (WAVEINGETFORMATINFO	= PROCEDURE)
symbol_vector = (WAVEINGETERRORTEXTA	= PROCEDURE)
symbol_vector = (WAVEINGETDEVCAPSEXA	= PROCEDURE)
symbol_vector = (WAVEINGETDEVCAPSA	= PROCEDURE)
symbol_vector = (WAVEINFORMATDETAILS	= PROCEDURE)
symbol_vector = (WAVEINCLOSE	= PROCEDURE)
symbol_vector = (WAVEINADDBUFFER	= PROCEDURE)
symbol_vector = (MMAUDISPOSEAUTH	= PROCEDURE)
symbol_vector = (MMAUFILENAME	= PROCEDURE)
symbol_vector = (MMAUGETAUTHBYADDR	= PROCEDURE)
symbol_vector = (MMAUGETBESTAUTHBYADDR	= PROCEDURE)
symbol_vector = (MMAULOCKAUTH	= PROCEDURE)
symbol_vector = (MMAUREADAUTH	= PROCEDURE)
symbol_vector = (MMAUUNLOCKAUTH	= PROCEDURE)
symbol_vector = (MMAUWRITEAUTH	= PROCEDURE)
symbol_vector = (CLIENT_OPEN_SERVER	= PROCEDURE)
symbol_vector = (CLIENT_WDMESSAGE	= PROCEDURE)
symbol_vector = (CLIENT_GET_NUMBER_DEVICES	= PROCEDURE)
symbol_vector = (CLIENT_CLASS_TO_DRIVER	= PROCEDURE)
symbol_vector = (CLIENT_GET_DRIVER_LIST	= PROCEDURE)
symbol_vector = (MMEWAITFORCALLBACKS	= PROCEDURE)
symbol_vector = (_FINDCALLBACKID	= PROCEDURE)
symbol_vector = (CMMDEFCALLBACKHANDLER	= PROCEDURE)
symbol_vector = (CMMREMOVECALLBACK	= PROCEDURE)
symbol_vector = (CMMREGISTERCALLBACK	= PROCEDURE)
symbol_vector = (CMMPROCESSCALLBACKEVENTS	= PROCEDURE)
symbol_vector = (MMESERVERFILEDESCRIPTOR	= PROCEDURE)
symbol_vector = (MMECHECKFORCALLBACKS	= PROCEDURE)
symbol_vector = (CMMPROCESSUSERCALLBACKS	= PROCEDURE)
symbol_vector = (MMEPROCESSCALLBACKS	= PROCEDURE)
symbol_vector = (MMEREGISTERUSERCALLBACK	= PROCEDURE)
symbol_vector = (CMMSETACCESSCONTROL	= PROCEDURE)
symbol_vector = (CMMENABLEACCESSCONTROL	= PROCEDURE)
symbol_vector = (CMMDISABLEACCESSCONTROL	= PROCEDURE)
symbol_vector = (CMMCHECKIFEVENT	= PROCEDURE)
symbol_vector = (CMMCHECKTYPEDEVENT	= PROCEDURE)
symbol_vector = (_GETTYPENUMBER	= PROCEDURE)
symbol_vector = (CMMCLASSMAPDEVICES	= PROCEDURE)
symbol_vector = (CMMCLASSGETNUMDEVS	= PROCEDURE)
symbol_vector = (CMMCLASSLISTDRIVERS	= PROCEDURE)
symbol_vector = (CMMCLASSLISTKEYNAMES	= PROCEDURE)
symbol_vector = (CMMCLOSESERVER	= PROCEDURE)
symbol_vector = (CMMSETAUTHORIZATION	= PROCEDURE)
symbol_vector = (_CMMSENDCLIENTPREFIX	= PROCEDURE)
symbol_vector = (_CMMDISCONNECTSERVER	= PROCEDURE)
symbol_vector = (_CMMCONNECTSERVER	= PROCEDURE)
symbol_vector = (CMMDRIVEROPENFROMID	= PROCEDURE)
symbol_vector = (CMMDRIVERSENDMESSAGE	= PROCEDURE)
symbol_vector = (CMMDRIVERCLOSE	= PROCEDURE)
symbol_vector = (CMMDRIVEROPEN	= PROCEDURE)
symbol_vector = (CMMGETERRORDATABASETEXT	= PROCEDURE)
symbol_vector = (CMMGETERRORTEXT	= PROCEDURE)
symbol_vector = (CMMSETERRORHANDLER	= PROCEDURE)
symbol_vector = (CMMSETIOERRORHANDLER	= PROCEDURE)
symbol_vector = (CMMFLUSH	= PROCEDURE)
symbol_vector = (CMMADDHOST	= PROCEDURE)
symbol_vector = (CMMREMOVEHOST	= PROCEDURE)
symbol_vector = (CMMREMOVEHOSTS	= PROCEDURE)
symbol_vector = (CMMADDHOSTS	= PROCEDURE)
symbol_vector = (CMMIFEVENT	= PROCEDURE)
symbol_vector = (_CMMDEFAULTIOERROR	= PROCEDURE)
symbol_vector = (_CMMIOERROR	= PROCEDURE)
symbol_vector = (_CMMENQ	= PROCEDURE)
symbol_vector = (_CMMERROR	= PROCEDURE)
symbol_vector = (_CMMWAITFORREADABLE	= PROCEDURE)
symbol_vector = (_CMMREAD	= PROCEDURE)
symbol_vector = (_CMMEATDATA	= PROCEDURE)
symbol_vector = (_CMMSETLASTREQUESTREAD	= PROCEDURE)
symbol_vector = (_CMMWAITFORWRITABLE	= PROCEDURE)
symbol_vector = (_CMMUNLOCKSERVER	= PROCEDURE)
symbol_vector = (_CMMLOCKSERVER	= PROCEDURE)
symbol_vector = (_CMMGETHOSTNAME	= PROCEDURE)
symbol_vector = (_CMMFREEQ	= PROCEDURE)
symbol_vector = (CMMFREE	= PROCEDURE)
symbol_vector = (_CMMALLOCSCRATCH	= PROCEDURE)
symbol_vector = (_CMMDEFAULTERROR	= PROCEDURE)
symbol_vector = (_CMMUNKNOWNWIREEVENT	= PROCEDURE)
symbol_vector = (_CMMWIRETOEVENT	= PROCEDURE)
symbol_vector = (_CMMUNKNOWNNATIVEEVENT	= PROCEDURE)
symbol_vector = (_CMMFLUSH	= PROCEDURE)
symbol_vector = (_CMMREPLY	= PROCEDURE)
symbol_vector = (_CMMALLOCID	= PROCEDURE)
symbol_vector = (_CMMSEND	= PROCEDURE)
symbol_vector = (_CMMREADPAD	= PROCEDURE)
symbol_vector = (_CMMREADEVENTS	= PROCEDURE)
symbol_vector = (_CMMEVENTSQUEUED	= PROCEDURE)
symbol_vector = (CMMLISTHOSTS	= PROCEDURE)
symbol_vector = (_CMMCONNECTIONNUMBER	= PROCEDURE)
symbol_vector = (CMMNOOP	= PROCEDURE)
symbol_vector = (_CMMNEXTREQUEST	= PROCEDURE)
symbol_vector = (_CMMLASTKNOWNREQUESTPROCESSED	= PROCEDURE)
symbol_vector = (_CMMQLENGTH	= PROCEDURE)
symbol_vector = (_CMMSERVERSTRING	= PROCEDURE)
symbol_vector = (_CMMVENDORRELEASE	= PROCEDURE)
symbol_vector = (_CMMPROTOCOLREVISION	= PROCEDURE)
symbol_vector = (_CMMPROTOCOLVERSION	= PROCEDURE)
symbol_vector = (_CMMSERVERVENDOR	= PROCEDURE)
symbol_vector = (CMMMAXREQUESTSIZE	= PROCEDURE)
symbol_vector = (CMMNEXTEVENT	= PROCEDURE)
symbol_vector = (_CMMFREESERVERSTRUCTURE	= PROCEDURE)
symbol_vector = (CMMOPENSERVER	= PROCEDURE)
symbol_vector = (CMMCHECKANDOPENSERVER	= PROCEDURE)
symbol_vector = (CMMPEEKEVENT	= PROCEDURE)
symbol_vector = (CMMPEEKIFEVENT	= PROCEDURE)
symbol_vector = (CMMEVENTSQUEUED	= PROCEDURE)
symbol_vector = (CMMPENDING	= PROCEDURE)
symbol_vector = (CMMPUTBACKEVENT	= PROCEDURE)
symbol_vector = (DELETELINKEDENTRY	= PROCEDURE)
symbol_vector = (MMEFREEBUFFER	= PROCEDURE)
symbol_vector = (MMEFREEMEM	= PROCEDURE)
symbol_vector = (MMSHMATTACH	= PROCEDURE)
symbol_vector = (_CMMALLOCSHARED	= PROCEDURE)
symbol_vector = (CMMALLOCBUFFERI	= PROCEDURE)
symbol_vector = (MMEALLOCBUFFERANDGETSHMINFO	= PROCEDURE)
symbol_vector = (MMEALLOCBUFFER	= PROCEDURE)
symbol_vector = (CMMALLOCMEMI	= PROCEDURE)
symbol_vector = (MMEALLOCMEM	= PROCEDURE)
symbol_vector = (CMMSYNC	= PROCEDURE)
symbol_vector = (_CMMSYNCFUNCTION	= PROCEDURE)
symbol_vector = (CMMSETAFTERFUNCTION	= PROCEDURE)
symbol_vector = (CMMSYNCHRONIZE	= PROCEDURE)
symbol_vector = (DEVHNDL_INITIALIZE_DEVI0G1NLQ2$	= PROCEDURE)
symbol_vector = (DEVHNDL_UCLASSDEVICEID_2FGVR35$	= PROCEDURE)
symbol_vector = (DEVHNDL_IS_UCLASSDEVICE03J93PU$	= PROCEDURE)
symbol_vector = (DEVHNDL_UCLASSDEVICEID_0B3P6FN$	= PROCEDURE)
symbol_vector = (DEVHNDL_DELETE_DEVICE_HANDLE	= PROCEDURE)
symbol_vector = (DEVHNDL_GET_DEVICE_CLASS	= PROCEDURE)
symbol_vector = (DEVHNDL_GET_DRIVER_DEVICE_ID	= PROCEDURE)
symbol_vector = (DEVHNDL_GET_CLASS_DEVICE_ID	= PROCEDURE)
symbol_vector = (DEVHNDL_GET_DRIVER_ADDRESS	= PROCEDURE)
symbol_vector = (DEVHNDL_GET_DWUSER_P	= PROCEDURE)
symbol_vector = (DEVHNDL_IS_VALID_DEVICE_HANDLE	= PROCEDURE)
symbol_vector = (DEVHNDL_ADD_NEW_DEVICE	= PROCEDURE)
symbol_vector = (ERRSTR_GET_ERROR_STRING	= PROCEDURE)
symbol_vector = (ICSENDMESSAGE	= PROCEDURE)
symbol_vector = (ICCALLBACKPROC	= PROCEDURE)
symbol_vector = (ICDUMPCHARSTRING	= PROCEDURE)
symbol_vector = (ICDUMPFOURCC	= PROCEDURE)
symbol_vector = (ICDUMPICINFO	= PROCEDURE)
symbol_vector = (ICDUMPDRIVERS	= PROCEDURE)
symbol_vector = (ICDUMP	= PROCEDURE)
symbol_vector = (_ICMINITIALIZEDRIVERS	= PROCEDURE)
symbol_vector = (ICREMOVE	= PROCEDURE)
symbol_vector = (ICOPEN	= PROCEDURE)
symbol_vector = (ICCLOSE	= PROCEDURE)
symbol_vector = (ICINFO	= PROCEDURE)
symbol_vector = (ICLOCATE	= PROCEDURE)
symbol_vector = (ICINSTALL	= PROCEDURE)
symbol_vector = (ICGETINFO	= PROCEDURE)
symbol_vector = (ICGETDISPLAYFORMAT	= PROCEDURE)
symbol_vector = (ICDRAWBEGIN	= PROCEDURE)
symbol_vector = (ICDRAW	= PROCEDURE)
symbol_vector = (ICDECOMPRESSUNPREPAREHEADER	= PROCEDURE)
symbol_vector = (ICDECOMPRESSPREPAREHEADER	= PROCEDURE)
symbol_vector = (ICDECOMPRESS	= PROCEDURE)
symbol_vector = (ICCOMPRESSUNPREPAREHEADER	= PROCEDURE)
symbol_vector = (ICCOMPRESSPREPAREHEADER	= PROCEDURE)
symbol_vector = (ICCOMPRESS	= PROCEDURE)
symbol_vector = (ERROR	= PROCEDURE)
symbol_vector = (FREE_IPCB	= PROCEDURE)
symbol_vector = (RECEIVE	= PROCEDURE)
symbol_vector = (IPC_CLIENT_DEBUG	= PROCEDURE)
symbol_vector = (POST_RECEIVE	= PROCEDURE)
symbol_vector = (GET_IPCB	= PROCEDURE)
symbol_vector = (NET$ADD_ITEM	= PROCEDURE)
symbol_vector = (CONNECT_INITIATE	= PROCEDURE)
symbol_vector = (INITIATE_CONNECTION	= PROCEDURE)
symbol_vector = (OPEN_ASSOCIATION	= PROCEDURE)
symbol_vector = (IPC_CREATE_CONNECTION	= PROCEDURE)
symbol_vector = (GETTIMEINMILLIS	= PROCEDURE)
symbol_vector = (STEVE	= PROCEDURE)
symbol_vector = (VMS_GETCLOCK	= PROCEDURE)
symbol_vector = (CLIENT_VMS_IOCTL	= PROCEDURE)
symbol_vector = (UNAME	= PROCEDURE)
symbol_vector = (TRANSCEIVE	= PROCEDURE)
symbol_vector = (REPLY	= PROCEDURE)
symbol_vector = (GETPAGESIZE	= PROCEDURE)
symbol_vector = (CLIENT_BCOPY	= PROCEDURE)
symbol_vector = (CLIENT_BZERO	= PROCEDURE)
symbol_vector = (RINDEX	= PROCEDURE)
symbol_vector = (IPC_CLOSE	= PROCEDURE)
symbol_vector = (COUNTBITS	= PROCEDURE)
symbol_vector = (AST_TIMER_ROUTINE	= PROCEDURE)
symbol_vector = (IPC_SELECT	= PROCEDURE)
symbol_vector = (TRANSMIT	= PROCEDURE)
symbol_vector = (IPC_WRITE	= PROCEDURE)
symbol_vector = (IPC_WRITEV	= PROCEDURE)
symbol_vector = (IPC_READ	= PROCEDURE)
symbol_vector = (IPC_READV	= PROCEDURE)
symbol_vector = (IPC_CLIENT_FCNTL	= PROCEDURE)
symbol_vector = (DISCONNECT_CONNECTION	= PROCEDURE)
symbol_vector = (FREE_BUFFER	= PROCEDURE)
symbol_vector = (RECEIVE_COMP	= PROCEDURE)
symbol_vector = (DISCONNECT_HANDLER	= PROCEDURE)
symbol_vector = (MMIOWRITE	= PROCEDURE)
symbol_vector = (MMIOSEEK	= PROCEDURE)
symbol_vector = (MMIOCREATECHUNK	= PROCEDURE)
symbol_vector = (MMIOASCEND	= PROCEDURE)
symbol_vector = (MMIOREAD	= PROCEDURE)
symbol_vector = (MMIODESCEND	= PROCEDURE)
symbol_vector = (MMIOSENDMESSAGE	= PROCEDURE)
symbol_vector = (MMIOFLUSH	= PROCEDURE)
symbol_vector = (MMIOSETBUFFER	= PROCEDURE)
symbol_vector = (MMIOSETINFO	= PROCEDURE)
symbol_vector = (MMIOPCOPYIOINFO	= PROCEDURE)
symbol_vector = (MMIOGETINFO	= PROCEDURE)
symbol_vector = (MMIORENAMEA	= PROCEDURE)
symbol_vector = (MMIOINSTALLIOPROCA	= PROCEDURE)
symbol_vector = (MMIOSTRINGTOFOURCCA	= PROCEDURE)
symbol_vector = (MMIOCLOSE	= PROCEDURE)
symbol_vector = (MMIOOPENA	= PROCEDURE)
symbol_vector = (MMIOADVANCE	= PROCEDURE)
symbol_vector = (MMEERROR	= PROCEDURE)
symbol_vector = (MMEWARNING	= PROCEDURE)
symbol_vector = (SA_GETMPEGAUDIOINFO	= PROCEDURE)
symbol_vector = (SAADDBUFFER	= PROCEDURE)
symbol_vector = (SASETDATASOURCE	= PROCEDURE)
symbol_vector = (SACOMPRESSEND	= PROCEDURE)
symbol_vector = (SACOMPRESS	= PROCEDURE)
symbol_vector = (SACOMPRESSBEGIN	= PROCEDURE)
symbol_vector = (SADECOMPRESSEND	= PROCEDURE)
symbol_vector = (SADECOMPRESS	= PROCEDURE)
symbol_vector = (SADECOMPRESSBEGIN	= PROCEDURE)
symbol_vector = (SAGETINPUTBITSTREAM	= PROCEDURE)
symbol_vector = (SAREGISTERCALLBACK	= PROCEDURE)
symbol_vector = (SACLOSECODEC	= PROCEDURE)
symbol_vector = (SAOPENCODEC	= PROCEDURE)
symbol_vector = (GSM_ADD	= PROCEDURE)
symbol_vector = (SA_INITGSM	= PROCEDURE)
symbol_vector = (GSM_RPE_DECODING	= PROCEDURE)
symbol_vector = (GSM_RPE_ENCODING	= PROCEDURE)
symbol_vector = (GSM_DIV	= PROCEDURE)
symbol_vector = (GSM_NORM	= PROCEDURE)
symbol_vector = (GSM_ASR	= PROCEDURE)
symbol_vector = (GSM_L_ASR	= PROCEDURE)
symbol_vector = (GSM_ASL	= PROCEDURE)
symbol_vector = (GSM_L_ASL	= PROCEDURE)
symbol_vector = (GSM_L_SUB	= PROCEDURE)
symbol_vector = (GSM_L_ADD	= PROCEDURE)
symbol_vector = (GSM_L_MULT	= PROCEDURE)
symbol_vector = (GSM_ABS	= PROCEDURE)
symbol_vector = (GSM_MULT_R	= PROCEDURE)
symbol_vector = (GSM_MULT	= PROCEDURE)
symbol_vector = (GSM_SUB	= PROCEDURE)
symbol_vector = (SA_GSMDECODE	= PROCEDURE)
symbol_vector = (SA_GSMENCODE	= PROCEDURE)
symbol_vector = (GSM_LONG_TERM_SYNTHESIS23GJNT5$	= PROCEDURE)
symbol_vector = (GSM_LONG_TERM_PREDICTOR	= PROCEDURE)
symbol_vector = (GSM_SHORT_TERM_SYNTHESIS_FILTER	= PROCEDURE)
symbol_vector = (GSM_SHORT_TERM_ANALYSIS_FILTER	= PROCEDURE)
symbol_vector = (SA_CRCUPDATE	= PROCEDURE)
symbol_vector = (SA_CRCCALCII	= PROCEDURE)
symbol_vector = (SA_CRCCALCI	= PROCEDURE)
symbol_vector = (SA_PICKTABLE	= PROCEDURE)
symbol_vector = (SA_HDR_TO_FRPS	= PROCEDURE)
symbol_vector = (SA_SMPFRQINDEX	= PROCEDURE)
symbol_vector = (SA_BITRATEINDEX	= PROCEDURE)
symbol_vector = (SA_SHOWSAMPLES	= PROCEDURE)
symbol_vector = (SA_SHOWSCALE	= PROCEDURE)
symbol_vector = (SA_SHOWBITALLOC	= PROCEDURE)
symbol_vector = (SA_SHOWHEADER	= PROCEDURE)
symbol_vector = (SA_DECODEINFO	= PROCEDURE)
symbol_vector = (SA_DECOMPRESSMPEG	= PROCEDURE)
symbol_vector = (SA_INITMPEGDECODER	= PROCEDURE)
symbol_vector = (SA_COMPRESSMPEG	= PROCEDURE)
symbol_vector = (SA_GETMPEGSAMPLESIZE	= PROCEDURE)
symbol_vector = (SA_ENDMPEGENCODER	= PROCEDURE)
symbol_vector = (SA_INITMPEGENCODER	= PROCEDURE)
symbol_vector = (SA_SETMPEGPARAMS	= PROCEDURE)
symbol_vector = (SA_PSYCHOANAL	= PROCEDURE)
symbol_vector = (I_PICK_MAX	= PROCEDURE)
symbol_vector = (SA_I_PSYCHO_ONE	= PROCEDURE)
symbol_vector = (SA_II_PSYCHO_ONE	= PROCEDURE)
symbol_vector = (SCBUFQUEUEGETHEAD	= PROCEDURE)
symbol_vector = (SCBUFQUEUEGETNUM	= PROCEDURE)
symbol_vector = (SCBUFQUEUEREMOVE	= PROCEDURE)
symbol_vector = (SCBUFQUEUEADD	= PROCEDURE)
symbol_vector = (SCBUFQUEUEDESTROY	= PROCEDURE)
symbol_vector = (SCBUFQUEUECREATE	= PROCEDURE)
symbol_vector = (SCBSDESTROY	= PROCEDURE)
symbol_vector = (SCBSFLUSHSOON	= PROCEDURE)
symbol_vector = (SCBSSEEKTOPOSITION	= PROCEDURE)
symbol_vector = (SCBSRESET	= PROCEDURE)
symbol_vector = (SC_BSSTOREDATAWORD	= PROCEDURE)
symbol_vector = (SCBSPUTBITS	= PROCEDURE)
symbol_vector = (SCBSFLUSH	= PROCEDURE)
symbol_vector = (SC_BSLOADDATAWORD	= PROCEDURE)
symbol_vector = (SCBSGETBITS	= PROCEDURE)
symbol_vector = (SCBSGETBYTESSTOPBEFORE	= PROCEDURE)
symbol_vector = (SCBSSKIPBITS	= PROCEDURE)
symbol_vector = (SCBSSEEKALIGNSTOPBEFORE	= PROCEDURE)
symbol_vector = (SCBSSEEKALIGNSTOPAT	= PROCEDURE)
symbol_vector = (SCBSSEEKALIGN	= PROCEDURE)
symbol_vector = (SCBSPEEKBITS	= PROCEDURE)
symbol_vector = (SCBSGETBITSVARLEN	= PROCEDURE)
symbol_vector = (SCBSPUTBIT	= PROCEDURE)
symbol_vector = (SCBSPUTBYTES	= PROCEDURE)
symbol_vector = (SCBSGETBIT	= PROCEDURE)
symbol_vector = (SCBSGETBYTES	= PROCEDURE)
symbol_vector = (SCBSPEEKBYTES	= PROCEDURE)
symbol_vector = (SCBSPEEKBIT	= PROCEDURE)
symbol_vector = (SCBSSKIPBYTES	= PROCEDURE)
symbol_vector = (SCBSCREATE	= PROCEDURE)
symbol_vector = (SCBSCREATEFROMDEVICE	= PROCEDURE)
symbol_vector = (SCBSCREATEFROMFILE	= PROCEDURE)
symbol_vector = (SCBSCREATEFROMNET	= PROCEDURE)
symbol_vector = (SCBSCREATEFROMBUFFERQUEUE	= PROCEDURE)
symbol_vector = (SCBSCREATEFROMBUFFER	= PROCEDURE)
symbol_vector = (SCBSSETFILTER	= PROCEDURE)
symbol_vector = (SCCREATEBMHEADER	= PROCEDURE)
symbol_vector = (SCCONVERTSEPYUVTOINTERLEAVED	= PROCEDURE)
symbol_vector = (SCCONVERTGRAYTOBLOCK	= PROCEDURE)
symbol_vector = (SCCONVERTSEP422TOBLOCKYUV	= PROCEDURE)
symbol_vector = (SCCONVERT422TOYUV_CHAR_C	= PROCEDURE)
symbol_vector = (SCINITRGBTOYUV	= PROCEDURE)
symbol_vector = (SCRGBINTERLTOYUVINTERL	= PROCEDURE)
symbol_vector = (SCRGBTOYUV	= PROCEDURE)
symbol_vector = (SCYUV422TORGB	= PROCEDURE)
symbol_vector = (SCYUV1611TORGB	= PROCEDURE)
symbol_vector = (SCYUV411TORGB	= PROCEDURE)
symbol_vector = (SCCONVERTSEPYUVTOOTHER	= PROCEDURE)
symbol_vector = (SCCONVERT422TOBLOCKYUV	= PROCEDURE)
symbol_vector = (SCSEPYUVTO422I	= PROCEDURE)
symbol_vector = (SCCONVERT422TOYUV_CHAR	= PROCEDURE)
symbol_vector = (SCCONVERT422PLANARTO422I	= PROCEDURE)
symbol_vector = (SCINITYUVCVT	= PROCEDURE)
symbol_vector = (SC_GETDITHERTEMPLATE10	= PROCEDURE)
symbol_vector = (SC_GETDITHERTEMPLATE15	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_GENERIC	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422I_GENERIC	= PROCEDURE)
symbol_vector = (SC_SIFRENDERYUVTORGBNN	= PROCEDURE)
symbol_vector = (SCISUPSIDEDOWN	= PROCEDURE)
symbol_vector = (VALIDATEBI_BITFIELDS	= PROCEDURE)
symbol_vector = (SCINITYUVTORGB	= PROCEDURE)
symbol_vector = (SCCOPYCLIP_C	= PROCEDURE)
symbol_vector = (SCCOPYMB_C	= PROCEDURE)
symbol_vector = (SCCOPYBLOCK_C	= PROCEDURE)
symbol_vector = (SCLOOPFILTER_C	= PROCEDURE)
symbol_vector = (SCCOPYMV8_C	= PROCEDURE)
symbol_vector = (SCCOPYREV_C	= PROCEDURE)
symbol_vector = (SCCOPYSUBCLIP_C	= PROCEDURE)
symbol_vector = (SCCOPYADDCLIP_C	= PROCEDURE)
symbol_vector = (SCCOPYCLIPTOPACKED422_C	= PROCEDURE)
symbol_vector = (SCCOPYCLIP_S	= PROCEDURE)
symbol_vector = (SCCOPYCLIPTOPACKED422_S	= PROCEDURE)
symbol_vector = (SCCOPYADDCLIP_S	= PROCEDURE)
symbol_vector = (SCLOOPFILTER_S	= PROCEDURE)
symbol_vector = (SCCOPYMV8_S	= PROCEDURE)
symbol_vector = (SCCOPYMV16_S	= PROCEDURE)
symbol_vector = (SCCOPYMB8_S	= PROCEDURE)
symbol_vector = (SCCOPYMB16_S	= PROCEDURE)
symbol_vector = (SCAVGMV_S	= PROCEDURE)
symbol_vector = (SCCOPYREV_S	= PROCEDURE)
symbol_vector = (SCCOPYSUBCLIP_S	= PROCEDURE)
symbol_vector = (SCIFDCT	= PROCEDURE)
symbol_vector = (SCIDCT8X8B	= PROCEDURE)
symbol_vector = (SCIDCT8X8	= PROCEDURE)
symbol_vector = (SCFDCT8X8_C	= PROCEDURE)
symbol_vector = (SCFDCT	= PROCEDURE)
symbol_vector = (SCFDCT8X8	= PROCEDURE)
symbol_vector = (SCGETERRORTEXT	= PROCEDURE)
symbol_vector = (SCFFTT4L	= PROCEDURE)
symbol_vector = (SCFFTTL	= PROCEDURE)
symbol_vector = (SCFFTTRL	= PROCEDURE)
symbol_vector = (SCFILEEXISTS	= PROCEDURE)
symbol_vector = (SCGETFILETYPE	= PROCEDURE)
symbol_vector = (SCFILEUNMAP	= PROCEDURE)
symbol_vector = (SCFILESIZE	= PROCEDURE)
symbol_vector = (SCFILEMAP	= PROCEDURE)
symbol_vector = (SCABS	= PROCEDURE)
symbol_vector = (SCARCTAN	= PROCEDURE)
symbol_vector = (SCDIGRV4	= PROCEDURE)
symbol_vector = (SCSQR	= PROCEDURE)
symbol_vector = (SCDISTANCE	= PROCEDURE)
symbol_vector = (SCMCY8	= PROCEDURE)
symbol_vector = (SCMCY16	= PROCEDURE)
symbol_vector = (SCMCX8	= PROCEDURE)
symbol_vector = (SCMCX16	= PROCEDURE)
symbol_vector = (SCMCXY8	= PROCEDURE)
symbol_vector = (SCMCXY16	= PROCEDURE)
symbol_vector = (SCALLOC	= PROCEDURE)
symbol_vector = (SCPAFREE	= PROCEDURE)
symbol_vector = (SCPAMALLOC	= PROCEDURE)
symbol_vector = (SCMEMCHECK	= PROCEDURE)
symbol_vector = (SCFREE	= PROCEDURE)
symbol_vector = (SCALLOC2	= PROCEDURE)
symbol_vector = (SCSORTDOUBLES	= PROCEDURE)
symbol_vector = (SC_DUMMY	= PROCEDURE)
symbol_vector = (SCSHOWIMAGECOLORS	= PROCEDURE)
symbol_vector = (SCDUMPCHAR	= PROCEDURE)
symbol_vector = (SCSHOWH261INFO	= PROCEDURE)
symbol_vector = (SCSHOWBMH	= PROCEDURE)
symbol_vector = (SCSHOWH261BMH	= PROCEDURE)
symbol_vector = (SCSHOWBUFFERINT	= PROCEDURE)
symbol_vector = (SCSHOWBUFFERFLOAT	= PROCEDURE)
symbol_vector = (SCSHOWBUFFER	= PROCEDURE)
symbol_vector = (SCREADCOMMANDSWITCHES	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422_24_BIT	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_YVU9_565	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_YVU9_555	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_YVU9_32_BIT	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_YVU9_24_BIT	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422I_565	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422I_555	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422I_32_BIT	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422I_24_BIT	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422_565	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422_555	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422_32_BIT	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422I_NNN	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422_NNN	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_422_INIT	= PROCEDURE)
symbol_vector = (YUV_TO_RGB_YVU9_NNN	= PROCEDURE)
symbol_vector = (SROPENRENDER	= PROCEDURE)
symbol_vector = (SR_SHIFTDOWN	= PROCEDURE)
symbol_vector = (SRSETCOLPACKFLAGS	= PROCEDURE)
symbol_vector = (SRRENDERGETPALETTE	= PROCEDURE)
symbol_vector = (SRGETSCALETYPE	= PROCEDURE)
symbol_vector = (SRGETSATURATION	= PROCEDURE)
symbol_vector = (SRGETBRIGHTNESS	= PROCEDURE)
symbol_vector = (SRGETCONTRAST	= PROCEDURE)
symbol_vector = (SRSETSCALETYPE	= PROCEDURE)
symbol_vector = (SRSETSATURATION	= PROCEDURE)
symbol_vector = (SRSETBRIGHTNESS	= PROCEDURE)
symbol_vector = (SRSETCONTRAST	= PROCEDURE)
symbol_vector = (SRRENDERFRAME	= PROCEDURE)
symbol_vector = (SRGETRENDERINFO	= PROCEDURE)
symbol_vector = (SRRENDERSETSHIFT	= PROCEDURE)
symbol_vector = (SRRENDERSETPALETTE	= PROCEDURE)
symbol_vector = (SRRENDEREND	= PROCEDURE)
symbol_vector = (SRRENDERBEGIN	= PROCEDURE)
symbol_vector = (SRCLOSERENDER	= PROCEDURE)
symbol_vector = (SR_CHROMAADJUST	= PROCEDURE)
symbol_vector = (SR_SIFDITHER420	= PROCEDURE)
symbol_vector = (SR_QSIFDITHER420	= PROCEDURE)
symbol_vector = (SR_YUV411COMP_TO_RGB24	= PROCEDURE)
symbol_vector = (SR_SIFDITHER422	= PROCEDURE)
symbol_vector = (SR_SIFDITHER422I	= PROCEDURE)
symbol_vector = (SR_QSIFDITHER422	= PROCEDURE)
symbol_vector = (SR_QSIFDITHER422I	= PROCEDURE)
symbol_vector = (SR_SIFDITHER_YVU9	= PROCEDURE)
symbol_vector = (SR_QSIFDITHER_YVU9	= PROCEDURE)
symbol_vector = (SR_DITHERSETUP	= PROCEDURE)
symbol_vector = (SR_GENADJUSTLUT	= PROCEDURE)
symbol_vector = (SR_YUVTORGB_PIXEL	= PROCEDURE)
symbol_vector = (SR_YUVBACKENDLUT	= PROCEDURE)
symbol_vector = (SR_RGBBACKENDLUT	= PROCEDURE)
symbol_vector = (SR_YBACKENDLUT	= PROCEDURE)
symbol_vector = (SR_GENBACKENDLUT	= PROCEDURE)
symbol_vector = (SR_GENMATRIX	= PROCEDURE)
symbol_vector = (SR_GENDITHER	= PROCEDURE)
symbol_vector = (SR_GETADJDEFAULTS	= PROCEDURE)
symbol_vector = (SR_GETDITHERLEVELS	= PROCEDURE)
symbol_vector = (SR_LOADBENDLUT	= PROCEDURE)
symbol_vector = (SR_MAKEDITHER	= PROCEDURE)
symbol_vector = (SR_MAKECHROMAADJ	= PROCEDURE)
symbol_vector = (SR_MAKELUMAADJ	= PROCEDURE)
symbol_vector = (SR_LOADADJUSTLUTS	= PROCEDURE)
symbol_vector = (SR_LUMINANCEADJUST	= PROCEDURE)
symbol_vector = (SR_RENDER_RGB	= PROCEDURE)
symbol_vector = (SR_RENDER_YVU9	= PROCEDURE)
symbol_vector = (SR_RENDER_YUV	= PROCEDURE)
symbol_vector = (SR_RENDER_RGB_SCALE	= PROCEDURE)
symbol_vector = (SVSETQUANTMODE	= PROCEDURE)
symbol_vector = (SVGETINFO	= PROCEDURE)
symbol_vector = (SVGETCOMPQTABLES	= PROCEDURE)
symbol_vector = (SVSETQUALITY	= PROCEDURE)
symbol_vector = (SVGETQUALITY	= PROCEDURE)
symbol_vector = (SVGETCOMPRESSSIZE	= PROCEDURE)
symbol_vector = (SVCOMPRESSQUERY	= PROCEDURE)
symbol_vector = (SVCOMPRESS	= PROCEDURE)
symbol_vector = (SVCOMPRESSEND	= PROCEDURE)
symbol_vector = (SVCOMPRESSBEGIN	= PROCEDURE)
symbol_vector = (SVSETDATADESTINATION	= PROCEDURE)
symbol_vector = (SVSETDATASOURCE	= PROCEDURE)
symbol_vector = (SVREGISTERCALLBACK	= PROCEDURE)
symbol_vector = (SVSETCOMPQTABLES	= PROCEDURE)
symbol_vector = (SVGETDCMPQTABLES	= PROCEDURE)
symbol_vector = (SVSETDCMPQTABLES	= PROCEDURE)
symbol_vector = (SVGETCOMPHTABLES	= PROCEDURE)
symbol_vector = (SVSETCOMPHTABLES	= PROCEDURE)
symbol_vector = (SVGETDCMPHTABLES	= PROCEDURE)
symbol_vector = (SVSETDCMPHTABLES	= PROCEDURE)
symbol_vector = (SVDECOMPRESSMPEG	= PROCEDURE)
symbol_vector = (SVFINDNEXTPICTURE	= PROCEDURE)
symbol_vector = (SVADDBUFFER	= PROCEDURE)
symbol_vector = (SVGETDATASOURCE	= PROCEDURE)
symbol_vector = (SVGETINPUTBITSTREAM	= PROCEDURE)
symbol_vector = (SVGETDATADESTINATION	= PROCEDURE)
symbol_vector = (SVDECOMPRESSEND	= PROCEDURE)
symbol_vector = (SVDECOMPRESS	= PROCEDURE)
symbol_vector = (SVDECOMPRESSQUERY	= PROCEDURE)
symbol_vector = (SVGETDECOMPRESSSIZE	= PROCEDURE)
symbol_vector = (SVDECOMPRESSBEGIN	= PROCEDURE)
symbol_vector = (SVCLOSECODEC	= PROCEDURE)
symbol_vector = (SVOPENCODEC	= PROCEDURE)
symbol_vector = (SV_GETJPEGIMAGEINFO	= PROCEDURE)
symbol_vector = (SV_MAKEJPEGTOC	= PROCEDURE)
symbol_vector = (SV_PREPROCESSFILE	= PROCEDURE)
symbol_vector = (SV_MAKEMPEGTOC	= PROCEDURE)
symbol_vector = (SV_AVIOPENFILE	= PROCEDURE)
symbol_vector = (SV_INITFILE	= PROCEDURE)
symbol_vector = (SV_READFRAME	= PROCEDURE)
symbol_vector = (SV_CHECK	= PROCEDURE)
symbol_vector = (SV_GETINDEXEDFRAME	= PROCEDURE)
symbol_vector = (SV_CONVERTINDEXTOTOC	= PROCEDURE)
symbol_vector = (SV_REINITJPEGDECODER	= PROCEDURE)
symbol_vector = (SV_DECODEJPEG	= PROCEDURE)
symbol_vector = (WRITEJPEGDATA	= PROCEDURE)
symbol_vector = (FLUSHBYTES	= PROCEDURE)
symbol_vector = (SV_HUFFENCODERTERM	= PROCEDURE)
symbol_vector = (EMITRESTART	= PROCEDURE)
symbol_vector = (SV_HUFFENCODERINIT	= PROCEDURE)
symbol_vector = (SV_ENCODEONEBLOCK	= PROCEDURE)
symbol_vector = (SV_ADDJPEGHEADER	= PROCEDURE)
symbol_vector = (SV_FORMATJPEGDATA	= PROCEDURE)
symbol_vector = (SV_ADDJPEGTRAILER	= PROCEDURE)
symbol_vector = (SV_COPYHTABLE	= PROCEDURE)
symbol_vector = (JROUNDUP	= PROCEDURE)
symbol_vector = (SV_INITJPEGDECODER	= PROCEDURE)
symbol_vector = (SV_CHECKCHROMA	= PROCEDURE)
symbol_vector = (SV_INITJPEGENCODER	= PROCEDURE)
symbol_vector = (SV_PARSESCANHEADER	= PROCEDURE)
symbol_vector = (SV_PARSEFRAME	= PROCEDURE)
symbol_vector = (SV_MAKEDECODERBLKTABLE	= PROCEDURE)
symbol_vector = (SV_LOADDEFAULTHTABLE	= PROCEDURE)
symbol_vector = (SV_MAKEHENCODINGTABLES	= PROCEDURE)
symbol_vector = (SV_MAKEENCODERBLKTABLE	= PROCEDURE)
symbol_vector = (SV_CONVERTQTABLE	= PROCEDURE)
symbol_vector = (SV_MAKEQTABLES	= PROCEDURE)
symbol_vector = (SV_MAKEHDECODINGTABLES	= PROCEDURE)
symbol_vector = (SV_PROCESSIBLOCK	= PROCEDURE)
symbol_vector = (SV_RESETDC	= PROCEDURE)
symbol_vector = (SV_DECODEMOTIONCOMP	= PROCEDURE)
symbol_vector = (SV_PROCESSBBLOCK	= PROCEDURE)
symbol_vector = (SV_PROCESSPBLOCK	= PROCEDURE)
symbol_vector = (SV_PROCESSPSKIPPEDBLOCK	= PROCEDURE)
symbol_vector = (SV_DECOMPRESSMPEG	= PROCEDURE)
symbol_vector = (SV_SYNCLOST	= PROCEDURE)
symbol_vector = (SV_FINDNEXTSTARTCODE	= PROCEDURE)
symbol_vector = (SV_PROCESSEXTENSIONS	= PROCEDURE)
symbol_vector = (SV_PROCESSPICTUREHEADER	= PROCEDURE)
symbol_vector = (SV_PROCESSGOPHEADER	= PROCEDURE)
symbol_vector = (SV_RESETQMATRIX	= PROCEDURE)
symbol_vector = (SV_PROCESSSEQUENCEHEADER	= PROCEDURE)
symbol_vector = (SV_PARSEMPEG	= PROCEDURE)
symbol_vector = (SV_FINDNEXTPICTURE	= PROCEDURE)
symbol_vector = (SV_GETMPEGIMAGEINFO	= PROCEDURE)
symbol_vector = (SV_INITMPEGIMAGEPTRS	= PROCEDURE)
symbol_vector = (SV_INITMPEGDECODER	= PROCEDURE)
symbol_vector = (SV_PROCESSSLICEHEADER	= PROCEDURE)
symbol_vector = (SV_SKIPPICTURE	= PROCEDURE)
symbol_vector = (SV_PARSEXS64	= PROCEDURE)
symbol_vector = (VIDEOMESSAGE	= PROCEDURE)
symbol_vector = (VIDEOCLOSE	= PROCEDURE)
symbol_vector = (VIDEOJ300SETVIDEOOUTYUVLUT	= PROCEDURE)
symbol_vector = (VIDEOSETFIELDMODE	= PROCEDURE)
symbol_vector = (VIDEOSETSTANDARD	= PROCEDURE)
symbol_vector = (VIDEOSETPORTNUM	= PROCEDURE)
symbol_vector = (VIDEOSETMIRROR	= PROCEDURE)
symbol_vector = (VIDEOSETQUALITY	= PROCEDURE)
symbol_vector = (VIDEOSETSATURATION	= PROCEDURE)
symbol_vector = (VIDEOSETSHARPENING	= PROCEDURE)
symbol_vector = (VIDEOSETBRIGHTNESS	= PROCEDURE)
symbol_vector = (VIDEOSETCONTRAST	= PROCEDURE)
symbol_vector = (VIDEOGETFIELDMODE	= PROCEDURE)
symbol_vector = (VIDEOGETSTANDARD	= PROCEDURE)
symbol_vector = (VIDEOGETPORTNUM	= PROCEDURE)
symbol_vector = (VIDEOGETMIRROR	= PROCEDURE)
symbol_vector = (VIDEOGETQUALITY	= PROCEDURE)
symbol_vector = (VIDEOGETSATURATION	= PROCEDURE)
symbol_vector = (VIDEOGETSHARPENING	= PROCEDURE)
symbol_vector = (VIDEOGETBRIGHTNESS	= PROCEDURE)
symbol_vector = (VIDEOGETCONTRAST	= PROCEDURE)
symbol_vector = (VIDEOUPDATE	= PROCEDURE)
symbol_vector = (VIDEOSTREAMUNPREPAREHEADER	= PROCEDURE)
symbol_vector = (VIDEOSTREAMSTOP	= PROCEDURE)
symbol_vector = (VIDEOSTREAMSTART	= PROCEDURE)
symbol_vector = (VIDEOSTREAMRESET	= PROCEDURE)
symbol_vector = (VIDEOSTREAMPREPAREHEADER	= PROCEDURE)
symbol_vector = (VIDEOSTREAMINIT	= PROCEDURE)
symbol_vector = (VIDEOSTREAMGETPOSITION	= PROCEDURE)
symbol_vector = (VIDEOSTREAMGETERROR	= PROCEDURE)
symbol_vector = (VIDEOSTREAMFINI	= PROCEDURE)
symbol_vector = (VIDEOSTREAMADDBUFFER	= PROCEDURE)
symbol_vector = (VIDEOOPEN	= PROCEDURE)
symbol_vector = (VIDEOGETNUMDEVS	= PROCEDURE)
symbol_vector = (VIDEOGETERRORTEXT	= PROCEDURE)
symbol_vector = (VIDEOGETCHANNELCAPS	= PROCEDURE)
symbol_vector = (VIDEOFRAME	= PROCEDURE)
symbol_vector = (VIDEODIALOG	= PROCEDURE)
symbol_vector = (VIDEOCONFIGURESTORAGE	= PROCEDURE)
symbol_vector = (VIDEOCONFIGURE	= PROCEDURE)
symbol_vector = (BITRATE	= DATA)
symbol_vector = (MULTIPLE	= DATA)
symbol_vector = (S_FREQ	= DATA)
symbol_vector = (S_FREQ_INT	= DATA)
symbol_vector = (CLIENT_EFN	= DATA)
symbol_vector = (CONN_QUEUE	= DATA)
symbol_vector = (CURRENT_READ_BUFFER	= DATA)
symbol_vector = (CURRENT_RX_BUFFER	= DATA)
symbol_vector = (GSM_A	= DATA)
symbol_vector = (GSM_B	= DATA)
symbol_vector = (GSM_DLB	= DATA)
symbol_vector = (GSM_FAC	= DATA)
symbol_vector = (GSM_H	= DATA)
symbol_vector = (GSM_INVA	= DATA)
symbol_vector = (GSM_MAC	= DATA)
symbol_vector = (GSM_MIC	= DATA)
symbol_vector = (GSM_NRFAC	= DATA)
symbol_vector = (GSM_QLB	= DATA)
symbol_vector = (INBUF_BASE	= DATA)
symbol_vector = (IPC_DISCONNECT_MASK	= DATA)
symbol_vector = (IPC_EXCEPTION_MASK	= DATA)
symbol_vector = (IPC_GLOBAL_SECTIONS	= DATA)
symbol_vector = (IPC_READ_MASK	= DATA)
symbol_vector = (IPC_SELECT_CONDITION	= DATA)
symbol_vector = (IPC_SELECT_MUTEX	= DATA)
symbol_vector = (IPC_WRITE_MASK	= DATA)
symbol_vector = (LAYER_NAMES	= DATA)
symbol_vector = (MODE_NAMES	= DATA)
symbol_vector = (READ_PACKETS_OUTSTANDING	= DATA)
symbol_vector = (SC_BITBUFFMASK	= DATA)
symbol_vector = (SELECT_FLAG	= DATA)
symbol_vector = (SHARED_MEM_ID	= DATA)
symbol_vector = (SLEEP_EF	= DATA)
symbol_vector = (TIME_WASTED_START	= DATA)
symbol_vector = (TRANS_COMP_QUEUE	= DATA)
symbol_vector = (_CMMCROWDSIZE	= DATA)
symbol_vector = (_CMMGLOBALSERVER_P	= DATA)
symbol_vector = (_CMMQFREE	= DATA)
symbol_vector = (_CMMQFREEFLAG	= DATA)
symbol_vector = (_CMMQFREEPTR	= DATA)
symbol_vector = (_ICINTERNALSCRATCHDWORD	= DATA)
symbol_vector = (_NUMSOFTCODEC	= DATA)
symbol_vector = (ASSOC_IPCB	= DATA)
symbol_vector = (BLUETOYUYV	= DATA)
symbol_vector = (CLIENT_CONN	= DATA)
symbol_vector = (CONNECT_IPCB	= DATA)
symbol_vector = (GREENTOYUYV	= DATA)
symbol_vector = (INPUTBUFFER	= DATA)
symbol_vector = (INPUTBUFFEROFFSET	= DATA)
symbol_vector = (MAXINPUTBYTES	= DATA)
symbol_vector = (NUMINPUTBYTES	= DATA)
symbol_vector = (PARAMS	= DATA)
symbol_vector = (REDTOYUYV	= DATA)
symbol_vector = (SHARED_MEM_ADDRESS	= DATA)
symbol_vector = (STATS	= DATA)
symbol_vector = (TIMER_EXPIRED	= DATA)
symbol_vector = (_CMMDEBUG	= DATA)
symbol_vector = (_CMMERRORFUNCTION	= DATA)
symbol_vector = (_CMMIOERRORFUNCTION	= DATA)
symbol_vector = (_ICINTERNALSCRATCHFALLBACK	= DATA)
symbol_vector = (_SERR_MSG	= DATA)
symbol_vector = (_VCARINTERNALMEM	= DATA)
symbol_vector = (_VCARINTERNALMEMFALLBACK	= DATA)
!
! ### PSECT list extracted from MMOV.MAP
!
symbol_vector = (CLIENT_EFN = PSECT)
symbol_vector = (CONN_QUEUE = PSECT)
symbol_vector = (CURRENT_READ_BUFFER = PSECT)
symbol_vector = (CURRENT_RX_BUFFER = PSECT)
symbol_vector = (GSM_A = PSECT)
symbol_vector = (GSM_B = PSECT)
symbol_vector = (GSM_DLB = PSECT)
symbol_vector = (GSM_FAC = PSECT)
symbol_vector = (GSM_H = PSECT)
symbol_vector = (GSM_INVA = PSECT)
symbol_vector = (GSM_MAC = PSECT)
symbol_vector = (GSM_MIC = PSECT)
symbol_vector = (GSM_NRFAC = PSECT)
symbol_vector = (GSM_QLB = PSECT)
symbol_vector = (INBUF_BASE = PSECT)
symbol_vector = (IPC_DISCONNECT_MASK = PSECT)
symbol_vector = (IPC_EXCEPTION_MASK = PSECT)
symbol_vector = (IPC_GLOBAL_SECTIONS = PSECT)
symbol_vector = (IPC_READ_MASK = PSECT)
symbol_vector = (IPC_SELECT_CONDITION = PSECT)
symbol_vector = (IPC_SELECT_MUTEX = PSECT)
symbol_vector = (IPC_WRITE_MASK = PSECT)
symbol_vector = (LAYER_NAMES = PSECT)
symbol_vector = (MODE_NAMES = PSECT)
symbol_vector = (READ_PACKETS_OUTSTANDING = PSECT)
symbol_vector = (SC_BITBUFFMASK = PSECT)
symbol_vector = (SELECT_FLAG = PSECT)
symbol_vector = (SHARED_MEM_ID = PSECT)
symbol_vector = (SLEEP_EF = PSECT)
symbol_vector = (TIME_WASTED_START = PSECT)
symbol_vector = (TRANS_COMP_QUEUE = PSECT)
symbol_vector = (_CMMCROWDSIZE = PSECT)
symbol_vector = (_CMMGLOBALSERVER_P = PSECT)
symbol_vector = (_CMMQFREE = PSECT)
symbol_vector = (_CMMQFREEFLAG = PSECT)
symbol_vector = (_CMMQFREEPTR = PSECT)
symbol_vector = (_ICINTERNALSCRATCHDWORD = PSECT)
symbol_vector = (_NUMSOFTCODEC = PSECT)
symbol_vector = (ASSOC_IPCB = PSECT)
symbol_vector = (BLUETOYUYV = PSECT)
symbol_vector = (CLIENT_CONN = PSECT)
symbol_vector = (CONNECT_IPCB = PSECT)
symbol_vector = (GREENTOYUYV = PSECT)
symbol_vector = (INPUTBUFFER = PSECT)
symbol_vector = (INPUTBUFFEROFFSET = PSECT)
symbol_vector = (MAXINPUTBYTES = PSECT)
symbol_vector = (NUMINPUTBYTES = PSECT)
symbol_vector = (PARAMS = PSECT)
symbol_vector = (REDTOYUYV = PSECT)
symbol_vector = (SHARED_MEM_ADDRESS = PSECT)
symbol_vector = (STATS = PSECT)
symbol_vector = (TIMER_EXPIRED = PSECT)
symbol_vector = (_CMMDEBUG = PSECT)
symbol_vector = (_CMMERRORFUNCTION = PSECT)
symbol_vector = (_CMMIOERRORFUNCTION = PSECT)
symbol_vector = (_ICINTERNALSCRATCHFALLBACK = PSECT)
symbol_vector = (_SERR_MSG = PSECT)
symbol_vector = (_VCARINTERNALMEM = PSECT)
symbol_vector = (_VCARINTERNALMEMFALLBACK = PSECT)

$OPEN/WRITE OUT BUILD.COM
$ IF (MMOV_SHARED.EQ.0).AND.(HAVE_MMOV.EQ.1)
$  THEN
$	WRITE OUT "$WRITE SYS$OUTPUT ""Creating Multimedia shared library"" "
$	WRITE OUT "$COPY SYS$INPUT MMOV$LNK.OPT"
$	WRITE OUT "SYS$SHARE:CMA$OPEN_RTL.EXE/SHARE"
$	WRITE OUT "SYS$SHARE:IPC$SHARE.EXE/SHARE"
$	WRITE OUT "$COPY SYS$INPUT JNK.C"
$	WRITE OUT "LINK() { }"
$	WRITE OUT "$CC/NAME=AS_IS JNK"
$	WRITE OUT "$LINK/SHARE=MMOV MMOV$LNK/OPT,MMOV$DEF/OPT,SYS$LIBRARY:MMOV/LIB,[]JNK"
$	WRITE OUT "$COPY MMOV.EXE SYS$SHARE:"
$	WRITE OUT "$DEL JNK.*;*"
$ ENDIF
$ WRITE OUT "$set def [.SRC]"
$! WRITE OUT "$DEF GL SYS$COMMON:[DECW$INCLUDE.GL_1_2]"
$ WRITE OUT "$OPEN/WRITE OUTT []LIBSDL.OPT"
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBSDL/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBSDLMAIN/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBVIDEO/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBVIDEO_X11/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBJOYSTICK/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBEVENTS/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBFILE/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBAUDIO/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBCDROM/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBTIMER/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBCPUINFO/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBTHREAD/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBTHREAD_GENERIC/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:LIBLOADSO/LIB"" "
$ WRITE OUT "$WRITE OUTT ""LIBSDL:STDLIB/LIB"" "
$ IF HAVE_OPENGL.EQ.1 THEN WRITE OUT "$WRITE OUTT ""SYS$SHARE:libglut.EXE/share"" "
$ IF HAVE_OPENGL.EQ.1 THEN WRITE OUT "$WRITE OUTT ""SYS$SHARE:libMesaGLU.exe/SHARE"" "
$ IF HAVE_OPENGL.EQ.1 THEN WRITE OUT "$WRITE OUTT ""SYS$SHARE:libMesaGL.exe/SHARE"" "
$ WRITE OUT "$WRITE OUTT ""Sys$Share:DECW$XMLibShr12.exe /Share"" "
$ WRITE OUT "$WRITE OUTT ""SYS$SHARE:DECW$XMuLibShrR5.EXE/SHARE"" "
$ WRITE OUT "$WRITE OUTT ""SYS$SHARE:DECW$XExtLibShr.EXE/SHARE"" "
$ WRITE OUT "$WRITE OUTT ""Sys$Share:DECW$XTLibShrR5.exe /Share"" "
$ WRITE OUT "$WRITE OUTT ""Sys$Share:DECW$XLibShr.exe /Share"" "
$ IF HAVE_MMOV.EQ.1 THEN WRITE OUT "$WRITE OUTT ""Sys$Share:MMOV/Share"" "
$ WRITE OUT "$CLOSE OUTT"
$!
$ WRITE OUT "$",MAKE,"/ignore=warn"
$ WRITE OUT "$ CURRENT = F$ENVIRONMENT (""DEFAULT"") "
$ WRITE OUT "$TIFF=CURRENT"
$ WRITE OUT "$OPEN/WRITE OUTT [-]LIBSDL$STARTUP.COM"
$! WRITE OUT "$TIFF[F$LOCATE(""]"",TIFF),9]:="".LIBTIFF]"""
$ WRITE OUT "$WRITE OUTT ""DEFINE LIBSDL ","'","'","TIFF'"" "
$ WRITE OUT "$set def [-.INCLUDE]"
$ WRITE OUT "$ CURRENT = F$ENVIRONMENT (""DEFAULT"") "
$ WRITE OUT "$TIFF=CURRENT"
$! WRITE OUT "$TIFF[F$LOCATE(""]"",TIFF),7]:="".TOOLS]"""
$ WRITE OUT "$WRITE OUTT ""DEFINE SDL ","'","'","TIFF'"" "
$ WRITE OUT "$set def [-]"
$ WRITE OUT "$CLOSE OUTT"
$ WRITE OUT "$OPEN/WRITE OUTT [.SRC]LIBSDL$SHR.OPT"
$ WRITE OUT "$WRITE OUTT ""SYS$SHARE:SDL$SHR/SHARE"" "
$ IF HAVE_OPENGL.EQ.1 THEN WRITE OUT "$WRITE OUTT ""SYS$SHARE:libglut.EXE/share"" "
$ IF HAVE_OPENGL.EQ.1 THEN WRITE OUT "$WRITE OUTT ""SYS$SHARE:libMesaGLU.exe/SHARE"" "
$ IF HAVE_OPENGL.EQ.1 THEN WRITE OUT "$WRITE OUTT ""SYS$SHARE:libMesaGL.exe/SHARE"" "
$ WRITE OUT "$CLOSE OUTT"
$!
$ WRITE OUT "$WRITE SYS$OUTPUT "" "" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** "" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""LIBSDL$STARTUP.COM has been created. "" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""This file setups all logicals needed. It should be execute before using LibSDL "" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""Nice place to call it - LOGIN.COM "" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""Usage:"" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""CC/INC=SDL TEST"" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""LINK/THREAD=UP TEST,LIBSDL:LIBSDL$SHR/OPT"" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""or"" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""LINK/THREAD=UP TEST,LIBSDL:LIBSDL/OPT"" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""for static libSDL"" "
$ WRITE OUT "$WRITE SYS$OUTPUT ""***************************************************************************** "" "
$CLOSE OUT
$!
$! SDL_config.h in [.SRC]
$!
$COPY SYS$INPUT [.INCLUDE]SDL_config.h
/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997-2006 Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Sam Lantinga
    slouken@libsdl.org

    patched by
    Alex Chupahin elvis_75@mail.ru
    Rostov-on-Don, Russia
*/

#ifndef _SDL_config_vms_h
#define _SDL_config_vms_h

#include <vms_x_fix.h>

#pragma pack (1)

#include "SDL_platform.h"

/* This is a set of defines to configure the SDL features */

#define HAVE_SYS_TYPES_H        1
#define HAVE_STDIO_H    1
#define STDC_HEADERS    1
#define HAVE_STRING_H   1
#define HAVE_INTTYPES_H 1
#define HAVE_CTYPE_H    1
#define HAVE_MATH_H     1
#define HAVE_SIGNAL_H   1

/* C library functions */
#define HAVE_MALLOC     1
#define HAVE_CALLOC     1
#define HAVE_REALLOC    1
#define HAVE_FREE       1
#define HAVE_GETENV     1
#define HAVE_PUTENV     1
#define HAVE_UNSETENV   1
#define HAVE_QSORT      1
#define HAVE_ABS        1
#define HAVE_BCOPY      1
#define HAVE_MEMSET     1
#define HAVE_MEMCPY     1
#define HAVE_MEMMOVE    1
#define HAVE_MEMCMP     1
#define HAVE_STRLEN     1
#define HAVE_STRDUP     1
#define HAVE_STRCHR     1
#define HAVE_STRRCHR    1
#define HAVE_STRSTR     1
#define HAVE_STRTOL     1
#define HAVE_STRTOUL    1
#define HAVE_STRTOLL    1
#define HAVE_STRTOULL   1
#define HAVE_STRTOD     1
#define HAVE_ATOI       1
#define HAVE_ATOF       1
#define HAVE_STRCMP     1
#define HAVE_STRNCMP    1
#define HAVE_STRCASECMP 1
#define HAVE_STRNCASECMP 1
#define HAVE_SSCANF     1
#define HAVE_SIGACTION  1
#define HAVE_SETJMP     1


/* Enable various cdrom drivers */
#define SDL_CDROM_VMS   1

/* Enable various input drivers */
#define SDL_JOYSTICK_DUMMY      1

#define RTLD_GLOBAL 0
#define SDL_LOADSO_DLOPEN     1
//#define SDL_LOADSO_DISABLED     1

#define SDL_THREAD_PTHREAD    1
 #define SDL_THREAD_PTHREAD_RECURSIVE_MUTEX    1
/* Enable various threading systems */
//#define SDL_THREAD_PTHREAD    1
//#define SDL_THREAD_PTHREAD_RECURSIVE_MUTEX    1

/* Enable various timer systems */
#define SDL_TIMER_UNIX  1

#define SDL_VIDEO_DRIVER_X11 1

/* Enable various video drivers */
//#define SDL_VIDEO_DRIVER_DUMMY        1


#define SDL_memset4 memset
$!
$!
$IF (CPU.NES."VAX")
$   THEN
$       APP SYS$INPUT [.include]SDL_config.h
	#define SDL_HAS_64BIT_TYPE 1
$ENDIF 
$!
$ IF (HAVE_GETENV.EQ.1)
$   THEN
$	APP SYS$INPUT [.include]SDL_config.h
	#define HAVE_GETENV 1
$ ENDIF
$!
$ IF (HAVE_ICONV.EQ.1)
$   THEN
$	APP SYS$INPUT [.include]SDL_config.h
	#define HAVE_ICONV 1
	#define HAVE_ICONV_H 1
$ ENDIF
$!
$ IF (HAVE_NANOSLEEP.EQ.1)
$   THEN
$	APP SYS$INPUT [.include]SDL_config.h
	#define HAVE_NANOSLEEP 1
$ ENDIF
$!
$ IF (HAVE_SNPRINTF.EQ.1)
$   THEN
$	APP SYS$INPUT [.include]SDL_config.h
	#define HAVE_SNPRINTF 1
$ ENDIF
$!
$ IF (HAVE_VSNPRINTF.EQ.1) 
$   THEN
$	APP SYS$INPUT [.include]SDL_config.h
	#define HAVE_VSNPRINTF 1
$ ENDIF
$!
$ IF (HAVE_STDINT_H.EQ.1)
$   THEN
$	APP SYS$INPUT [.include]SDL_config.h
	#define HAVE_STDINT_H 1
$ ENDIF
$!
$ IF (HAVE_MMOV.EQ.1)
$  THEN
$	APP SYS$INPUT [.include]SDL_config.h
	#define SDL_AUDIO_DRIVER_MMEAUDIO 1
	#define SDL_AUDIO_DISABLED      0
$  ELSE
$	APP SYS$INPUT [.include]SDL_config.h
	#define SDL_AUDIO_DISABLED      1
$ ENDIF
$ IF (HAVE_OPENGL.EQ.1)
$  THEN
$	APP SYS$INPUT [.include]SDL_config.h
/* Enable OpenGL support */
	#define SDL_VIDEO_OPENGL        1
	#define OPENGL_VMS "libMesaGL.exe"
	#define SDL_VIDEO_OPENGL_GLX 1
$ ENDIF
$!
$ APP SYS$INPUT [.include]SDL_config.h
 #endif
$!
$!
$! Writing UNIVERSAL=LIBSDL$DEF.OPT
$ IF (SHARED.EQ.32)
$   THEN
$	COPY SYS$INPUT [.SRC]LIBSDL$DEF.OPT
UNIVERSAL=SDL_Init
UNIVERSAL=SDL_InitSubSystem
UNIVERSAL=SDL_QuitSubSystem
UNIVERSAL=SDL_WasInit
UNIVERSAL=SDL_Quit
UNIVERSAL=SDL_GetAppState
UNIVERSAL=SDL_AudioInit
UNIVERSAL=SDL_AudioQuit
UNIVERSAL=SDL_AudioDriverName
UNIVERSAL=SDL_OpenAudio
UNIVERSAL=SDL_GetAudioStatus
UNIVERSAL=SDL_PauseAudio
UNIVERSAL=SDL_LoadWAV_RW
UNIVERSAL=SDL_FreeWAV
UNIVERSAL=SDL_BuildAudioCVT
UNIVERSAL=SDL_ConvertAudio
UNIVERSAL=SDL_MixAudio
UNIVERSAL=SDL_LockAudio
UNIVERSAL=SDL_UnlockAudio
UNIVERSAL=SDL_CloseAudio
UNIVERSAL=SDL_CDNumDrives
UNIVERSAL=SDL_CDName
UNIVERSAL=SDL_CDOpen
UNIVERSAL=SDL_CDStatus
UNIVERSAL=SDL_CDPlayTracks
UNIVERSAL=SDL_CDPlay
UNIVERSAL=SDL_CDPause
UNIVERSAL=SDL_CDResume
UNIVERSAL=SDL_CDStop
UNIVERSAL=SDL_CDEject
UNIVERSAL=SDL_CDClose
UNIVERSAL=SDL_HasRDTSC
UNIVERSAL=SDL_HasMMX
UNIVERSAL=SDL_HasMMXExt
UNIVERSAL=SDL_Has3DNow
UNIVERSAL=SDL_Has3DNowExt
UNIVERSAL=SDL_HasSSE
UNIVERSAL=SDL_HasSSE2
UNIVERSAL=SDL_HasAltiVec
UNIVERSAL=SDL_SetError
UNIVERSAL=SDL_GetError
UNIVERSAL=SDL_ClearError
UNIVERSAL=SDL_Error
UNIVERSAL=SDL_PumpEvents
UNIVERSAL=SDL_PeepEvents
UNIVERSAL=SDL_PollEvent
UNIVERSAL=SDL_WaitEvent
UNIVERSAL=SDL_PushEvent
UNIVERSAL=SDL_SetEventFilter
UNIVERSAL=SDL_GetEventFilter
UNIVERSAL=SDL_EventState
UNIVERSAL=SDL_NumJoysticks
UNIVERSAL=SDL_JoystickName
UNIVERSAL=SDL_JoystickOpen
UNIVERSAL=SDL_JoystickOpened
UNIVERSAL=SDL_JoystickIndex
UNIVERSAL=SDL_JoystickNumAxes
UNIVERSAL=SDL_JoystickNumBalls
UNIVERSAL=SDL_JoystickNumHats
UNIVERSAL=SDL_JoystickNumButtons
UNIVERSAL=SDL_JoystickUpdate
UNIVERSAL=SDL_JoystickEventState
UNIVERSAL=SDL_JoystickGetAxis
UNIVERSAL=SDL_JoystickGetHat
UNIVERSAL=SDL_JoystickGetBall
UNIVERSAL=SDL_JoystickGetButton
UNIVERSAL=SDL_JoystickClose
UNIVERSAL=SDL_EnableUNICODE
UNIVERSAL=SDL_EnableKeyRepeat
UNIVERSAL=SDL_GetKeyRepeat
UNIVERSAL=SDL_GetKeyState
UNIVERSAL=SDL_GetModState
UNIVERSAL=SDL_SetModState
UNIVERSAL=SDL_GetKeyName
UNIVERSAL=SDL_LoadObject
UNIVERSAL=SDL_LoadFunction
UNIVERSAL=SDL_UnloadObject
UNIVERSAL=SDL_GetMouseState
UNIVERSAL=SDL_GetRelativeMouseState
UNIVERSAL=SDL_WarpMouse
UNIVERSAL=SDL_CreateCursor
UNIVERSAL=SDL_SetCursor
UNIVERSAL=SDL_GetCursor
UNIVERSAL=SDL_FreeCursor
UNIVERSAL=SDL_ShowCursor
UNIVERSAL=SDL_CreateMutex
UNIVERSAL=SDL_mutexP
UNIVERSAL=SDL_mutexV
UNIVERSAL=SDL_DestroyMutex
UNIVERSAL=SDL_CreateSemaphore
UNIVERSAL=SDL_DestroySemaphore
UNIVERSAL=SDL_SemWait
UNIVERSAL=SDL_SemTryWait
UNIVERSAL=SDL_SemWaitTimeout
UNIVERSAL=SDL_SemPost
UNIVERSAL=SDL_SemValue
UNIVERSAL=SDL_CreateCond
UNIVERSAL=SDL_DestroyCond
UNIVERSAL=SDL_CondSignal
UNIVERSAL=SDL_CondBroadcast
UNIVERSAL=SDL_CondWait
UNIVERSAL=SDL_CondWaitTimeout
UNIVERSAL=SDL_RWFromFile
UNIVERSAL=SDL_RWFromFP
UNIVERSAL=SDL_RWFromMem
UNIVERSAL=SDL_RWFromConstMem
UNIVERSAL=SDL_AllocRW
UNIVERSAL=SDL_FreeRW
UNIVERSAL=SDL_ReadLE16
UNIVERSAL=SDL_ReadBE16
UNIVERSAL=SDL_ReadLE32
UNIVERSAL=SDL_ReadBE32
UNIVERSAL=SDL_ReadLE64
UNIVERSAL=SDL_ReadBE64
UNIVERSAL=SDL_WriteLE16
UNIVERSAL=SDL_WriteBE16
UNIVERSAL=SDL_WriteLE32
UNIVERSAL=SDL_WriteBE32
UNIVERSAL=SDL_WriteLE64
UNIVERSAL=SDL_WriteBE64
UNIVERSAL=SDL_GetWMInfo
UNIVERSAL=SDL_CreateThread
UNIVERSAL=SDL_ThreadID
UNIVERSAL=SDL_GetThreadID
UNIVERSAL=SDL_WaitThread
UNIVERSAL=SDL_KillThread
UNIVERSAL=SDL_GetTicks
UNIVERSAL=SDL_Delay
UNIVERSAL=SDL_SetTimer
UNIVERSAL=SDL_AddTimer
UNIVERSAL=SDL_RemoveTimer
UNIVERSAL=SDL_Linked_Version
UNIVERSAL=SDL_VideoInit
UNIVERSAL=SDL_VideoQuit
UNIVERSAL=SDL_VideoDriverName
UNIVERSAL=SDL_GetVideoSurface
UNIVERSAL=SDL_GetVideoInfo
UNIVERSAL=SDL_VideoModeOK
UNIVERSAL=SDL_ListModes
UNIVERSAL=SDL_SetVideoMode
UNIVERSAL=SDL_UpdateRects
UNIVERSAL=SDL_UpdateRect
UNIVERSAL=SDL_Flip
UNIVERSAL=SDL_SetGamma
UNIVERSAL=SDL_SetGammaRamp
UNIVERSAL=SDL_GetGammaRamp
UNIVERSAL=SDL_SetColors
UNIVERSAL=SDL_SetPalette
UNIVERSAL=SDL_MapRGB
UNIVERSAL=SDL_MapRGBA
UNIVERSAL=SDL_GetRGB
UNIVERSAL=SDL_GetRGBA
UNIVERSAL=SDL_CreateRGBSurface
UNIVERSAL=SDL_CreateRGBSurfaceFrom
UNIVERSAL=SDL_FreeSurface
UNIVERSAL=SDL_LockSurface
UNIVERSAL=SDL_UnlockSurface
UNIVERSAL=SDL_LoadBMP_RW
UNIVERSAL=SDL_SaveBMP_RW
UNIVERSAL=SDL_SetColorKey
UNIVERSAL=SDL_SetAlpha
UNIVERSAL=SDL_SetClipRect
UNIVERSAL=SDL_GetClipRect
UNIVERSAL=SDL_ConvertSurface
UNIVERSAL=SDL_UpperBlit
UNIVERSAL=SDL_LowerBlit
UNIVERSAL=SDL_FillRect
UNIVERSAL=SDL_DisplayFormat
UNIVERSAL=SDL_DisplayFormatAlpha
UNIVERSAL=SDL_CreateYUVOverlay
UNIVERSAL=SDL_LockYUVOverlay
UNIVERSAL=SDL_UnlockYUVOverlay
UNIVERSAL=SDL_DisplayYUVOverlay
UNIVERSAL=SDL_FreeYUVOverlay
UNIVERSAL=SDL_GL_LoadLibrary
UNIVERSAL=SDL_GL_GetProcAddress
UNIVERSAL=SDL_GL_SetAttribute
UNIVERSAL=SDL_GL_GetAttribute
UNIVERSAL=SDL_GL_SwapBuffers
UNIVERSAL=SDL_GL_UpdateRects
UNIVERSAL=SDL_GL_Lock
UNIVERSAL=SDL_GL_Unlock
UNIVERSAL=SDL_WM_SetCaption
UNIVERSAL=SDL_WM_GetCaption
UNIVERSAL=SDL_WM_SetIcon
UNIVERSAL=SDL_WM_IconifyWindow
UNIVERSAL=SDL_WM_ToggleFullScreen
UNIVERSAL=SDL_WM_GrabInput
UNIVERSAL=SDL_SoftStretch
UNIVERSAL=SDL_iconv_string
$ ENDIF
$ IF (SHARED.EQ.64)
$   THEN
$       COPY SYS$INPUT [.SRC]LIBSDL$DEF.OPT
case_sensitive=YES
SYMBOL_VECTOR= (-
SDL_Init=PROCEDURE,-
SDL_InitSubSystem=PROCEDURE,-
SDL_QuitSubSystem=PROCEDURE,-
SDL_WasInit=PROCEDURE,-
SDL_Quit=PROCEDURE,-
SDL_GetAppState=PROCEDURE,-
SDL_AudioInit=PROCEDURE,-
SDL_AudioQuit=PROCEDURE,-
SDL_AudioDriverName=PROCEDURE,-
SDL_OpenAudio=PROCEDURE,-
SDL_GetAudioStatus=PROCEDURE,-
SDL_PauseAudio=PROCEDURE,-
SDL_LoadWAV_RW=PROCEDURE,-
SDL_FreeWAV=PROCEDURE,-
SDL_BuildAudioCVT=PROCEDURE,-
SDL_ConvertAudio=PROCEDURE,-
SDL_MixAudio=PROCEDURE,-
SDL_LockAudio=PROCEDURE,-
SDL_UnlockAudio=PROCEDURE,-
SDL_CloseAudio=PROCEDURE,-
SDL_CDNumDrives=PROCEDURE,-
SDL_CDName=PROCEDURE,-
SDL_CDOpen=PROCEDURE,-
SDL_CDStatus=PROCEDURE,-
SDL_CDPlayTracks=PROCEDURE,-
SDL_CDPlay=PROCEDURE,-
SDL_CDPause=PROCEDURE,-
SDL_CDResume=PROCEDURE,-
SDL_CDStop=PROCEDURE,-
SDL_CDEject=PROCEDURE,-
SDL_CDClose=PROCEDURE,-
SDL_HasRDTSC=PROCEDURE,-
SDL_HasMMX=PROCEDURE,-
SDL_HasMMXExt=PROCEDURE,-
SDL_Has3DNow=PROCEDURE,-
SDL_Has3DNowExt=PROCEDURE,-
SDL_HasSSE=PROCEDURE,-
SDL_HasSSE2=PROCEDURE,-
SDL_HasAltiVec=PROCEDURE,-
SDL_SetError=PROCEDURE,-
SDL_GetError=PROCEDURE,-
SDL_ClearError=PROCEDURE,-
SDL_Error=PROCEDURE,-
SDL_PumpEvents=PROCEDURE,-
SDL_PeepEvents=PROCEDURE,-
SDL_PollEvent=PROCEDURE,-
SDL_WaitEvent=PROCEDURE,-
SDL_PushEvent=PROCEDURE,-
SDL_SetEventFilter=PROCEDURE,-
SDL_GetEventFilter=PROCEDURE,-
SDL_EventState=PROCEDURE,-
SDL_NumJoysticks=PROCEDURE,-
SDL_JoystickName=PROCEDURE,-
SDL_JoystickOpen=PROCEDURE,-
SDL_JoystickOpened=PROCEDURE,-
SDL_JoystickIndex=PROCEDURE,-
SDL_JoystickNumAxes=PROCEDURE,-
SDL_JoystickNumBalls=PROCEDURE,-
SDL_JoystickNumHats=PROCEDURE,-
SDL_JoystickNumButtons=PROCEDURE,-
SDL_JoystickUpdate=PROCEDURE,-
SDL_JoystickEventState=PROCEDURE,-
SDL_JoystickGetAxis=PROCEDURE,-
SDL_JoystickGetHat=PROCEDURE,-
SDL_JoystickGetBall=PROCEDURE,-
SDL_JoystickGetButton=PROCEDURE,-
SDL_JoystickClose=PROCEDURE,-
SDL_EnableUNICODE=PROCEDURE,-
SDL_EnableKeyRepeat=PROCEDURE,-
SDL_GetKeyRepeat=PROCEDURE,-
SDL_GetKeyState=PROCEDURE,-
SDL_GetModState=PROCEDURE,-
SDL_SetModState=PROCEDURE,-
SDL_GetKeyName=PROCEDURE,-
SDL_LoadObject=PROCEDURE,-
SDL_LoadFunction=PROCEDURE,-
SDL_UnloadObject=PROCEDURE,-
SDL_GetMouseState=PROCEDURE,-
SDL_GetRelativeMouseState=PROCEDURE,-
SDL_WarpMouse=PROCEDURE,-
SDL_CreateCursor=PROCEDURE,-
SDL_SetCursor=PROCEDURE,-
SDL_GetCursor=PROCEDURE,-
SDL_FreeCursor=PROCEDURE,-
SDL_ShowCursor=PROCEDURE,-
SDL_CreateMutex=PROCEDURE,-
SDL_mutexP=PROCEDURE,-
SDL_mutexV=PROCEDURE,-
SDL_DestroyMutex=PROCEDURE,-
SDL_CreateSemaphore=PROCEDURE,-
SDL_DestroySemaphore=PROCEDURE,-
SDL_SemWait=PROCEDURE,-
SDL_SemTryWait=PROCEDURE,-
SDL_SemWaitTimeout=PROCEDURE,-
SDL_SemPost=PROCEDURE,-
SDL_SemValue=PROCEDURE,-
SDL_CreateCond=PROCEDURE,-
SDL_DestroyCond=PROCEDURE,-
SDL_CondSignal=PROCEDURE,-
SDL_CondBroadcast=PROCEDURE,-
SDL_CondWait=PROCEDURE,-
SDL_CondWaitTimeout=PROCEDURE,-
SDL_RWFromFile=PROCEDURE,-
SDL_RWFromFP=PROCEDURE,-
SDL_RWFromMem=PROCEDURE,-
SDL_RWFromConstMem=PROCEDURE,-
SDL_AllocRW=PROCEDURE,-
SDL_FreeRW=PROCEDURE,-
SDL_ReadLE16=PROCEDURE,-
SDL_ReadBE16=PROCEDURE,-
SDL_ReadLE32=PROCEDURE,-
SDL_ReadBE32=PROCEDURE,-
SDL_ReadLE64=PROCEDURE,-
SDL_ReadBE64=PROCEDURE,-
SDL_WriteLE16=PROCEDURE,-
SDL_WriteBE16=PROCEDURE,-
SDL_WriteLE32=PROCEDURE,-
SDL_WriteBE32=PROCEDURE,-
SDL_WriteLE64=PROCEDURE,-
SDL_WriteBE64=PROCEDURE,-
SDL_GetWMInfo=PROCEDURE,-
SDL_CreateThread=PROCEDURE,-
SDL_ThreadID=PROCEDURE,-
SDL_GetThreadID=PROCEDURE,-
SDL_WaitThread=PROCEDURE,-
SDL_KillThread=PROCEDURE,-
SDL_GetTicks=PROCEDURE,-
SDL_Delay=PROCEDURE,-
SDL_SetTimer=PROCEDURE,-
SDL_AddTimer=PROCEDURE,-
SDL_RemoveTimer=PROCEDURE,-
SDL_Linked_Version=PROCEDURE,-
SDL_VideoInit=PROCEDURE,-
SDL_VideoQuit=PROCEDURE,-
SDL_VideoDriverName=PROCEDURE,-
SDL_GetVideoSurface=PROCEDURE,-
SDL_GetVideoInfo=PROCEDURE,-
SDL_VideoModeOK=PROCEDURE,-
SDL_ListModes=PROCEDURE,-
SDL_SetVideoMode=PROCEDURE,-
SDL_UpdateRects=PROCEDURE,-
SDL_UpdateRect=PROCEDURE,-
SDL_Flip=PROCEDURE,-
SDL_SetGamma=PROCEDURE,-
SDL_SetGammaRamp=PROCEDURE,-
SDL_GetGammaRamp=PROCEDURE,-
SDL_SetColors=PROCEDURE,-
SDL_SetPalette=PROCEDURE,-
SDL_MapRGB=PROCEDURE,-
SDL_MapRGBA=PROCEDURE,-
SDL_GetRGB=PROCEDURE,-
SDL_GetRGBA=PROCEDURE,-
SDL_CreateRGBSurface=PROCEDURE,-
SDL_CreateRGBSurfaceFrom=PROCEDURE,-
SDL_FreeSurface=PROCEDURE,-
SDL_LockSurface=PROCEDURE,-
SDL_UnlockSurface=PROCEDURE,-
SDL_LoadBMP_RW=PROCEDURE,-
SDL_SaveBMP_RW=PROCEDURE,-
SDL_SetColorKey=PROCEDURE,-
SDL_SetAlpha=PROCEDURE,-
SDL_SetClipRect=PROCEDURE,-
SDL_GetClipRect=PROCEDURE,-
SDL_ConvertSurface=PROCEDURE,-
SDL_UpperBlit=PROCEDURE,-
SDL_LowerBlit=PROCEDURE,-
SDL_FillRect=PROCEDURE,-
SDL_DisplayFormat=PROCEDURE,-
SDL_DisplayFormatAlpha=PROCEDURE,-
SDL_CreateYUVOverlay=PROCEDURE,-
SDL_LockYUVOverlay=PROCEDURE,-
SDL_UnlockYUVOverlay=PROCEDURE,-
SDL_DisplayYUVOverlay=PROCEDURE,-
SDL_FreeYUVOverlay=PROCEDURE,-
SDL_GL_LoadLibrary=PROCEDURE,-
SDL_GL_GetProcAddress=PROCEDURE,-
SDL_GL_SetAttribute=PROCEDURE,-
SDL_GL_GetAttribute=PROCEDURE,-
SDL_GL_SwapBuffers=PROCEDURE,-
SDL_GL_UpdateRects=PROCEDURE,-
SDL_GL_Lock=PROCEDURE,-
SDL_GL_Unlock=PROCEDURE,-
SDL_WM_SetCaption=PROCEDURE,-
SDL_WM_GetCaption=PROCEDURE,-
SDL_WM_SetIcon=PROCEDURE,-
SDL_WM_IconifyWindow=PROCEDURE,-
SDL_WM_ToggleFullScreen=PROCEDURE,-
SDL_WM_GrabInput=PROCEDURE,-
SDL_iconv_string=PROCEDURE,-
SDL_SoftStretch=PROCEDURE)
$ENDIF
$!
$!
$!
$COPY SYS$INPUT [.SRC]DESCRIP.MMS
# Makefile for DEC C compilers.
#
.first
	def LIBSDL []
        set def [.AUDIO]
        $(mms)
        set def [-.CDROM]
        $(mms)
        set def [-.CPUINFO]
        $(mms)
        set def [-.EVENTS]
        $(mms)
        set def [-.FILE]
        $(mms)
        set def [-.JOYSTICK]
        $(mms)
        set def [-.LOADSO]
        $(mms)
        set def [-.MAIN]
        $(mms)
        set def [-.TIMER]
        $(mms)
        set def [-.VIDEO]
        $(mms)/ign=warn
        set def [-.STDLIB]
        $(mms)
        set def [-.THREAD]
        $(mms)
        set def [-]
CC=cc

$IF CPU.EQS."VAX"
$ THEN
$	APP SYS$INPUT [.SRC]DESCRIP.MMS
CFLAGS = /NOWARN /INCLUDE=([],[-.include], [.THREAD], [.VIDEO], [.THREAD.GENERIC], X11:) /DEFINE=(HAVE_CONFIG_H) /DEB \
$ ELSE
$	APP SYS$INPUT [.SRC]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/NOWARN /INCLUDE=([],[-.include], [.THREAD], [.VIDEO], [.THREAD.GENERIC], X11:) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE \
$ENDIF

$APP SYS$INPUT [.SRC]DESCRIP.MMS
/OPTIMIZE=(INLINE=SPEED)

OBJ = sdl.obj,sdl_error.obj,sdl_fatal.obj

ALL : sdl$shr.exe
	COPY sdl$shr.exe SYS$SHARE:


sdl$shr.exe : libsdl.olb
        LINK/SHARE=sdl$shr.exe [.MAIN.DUMMY]sdl_dummy_main,[]libsdl/OPT,[]libsdl$def/OPT 

sdl.obj : sdl.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_error.obj : sdl_error.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_fatal.obj : sdl_fatal.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

libsdl.olb : $(OBJ)
        LIB/CREA []libsdl.olb $(OBJ)

CLEAN : 
	DEL [...]*.obj;*
	DEL [...]*.olb;*
	DEL [...]*.exe;*


$!
$! 
$!
$IF (HAVE_MMOV.EQ.1)
$ THEN
$	COPY SYS$INPUT [.SRC.AUDIO]DESCRIP.MMS
.FIRST
        set def [.VMS]
        $(MMS)
        set def [-]

DRIVER = [.VMS]sdl_vmsaudio.obj

$ ELSE
$	COPY SYS$INPUT [.SRC.AUDIO]DESCRIP.MMS
.FIRST
        set def [.DUMMY]
        $(MMS)
        set def [-]

DRIVER = [.DUMMY]sdl_dummyaudio.obj

$ENDIF
$!
$APP SYS$INPUT [.SRC.AUDIO]DESCRIP.MMS

CC=cc
$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.AUDIO]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /WARN=(DIS=EMPTYFILE) /OBJ=$(MMS$TARGET) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.AUDIO]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /WARN=(DIS=EMPTYFILE) /OBJ=$(MMS$TARGET) /DEB /FLOAT=IEEE
$ENDIF

$       APP SYS$INPUT [.SRC.AUDIO]DESCRIP.MMS

OBJ = sdl_audio.obj, \
sdl_audiocvt.obj, \
sdl_audiodev.obj, \
sdl_mixer.obj, \
sdl_wave.obj


ALL : libaudio.olb
        cop libaudio.olb [-]


libaudio.olb : $(OBJ)
        lib/crea libaudio $(OBJ), $(DRIVER)

sdl_audio.obj : sdl_audio.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_audiocvt.obj : sdl_audiocvt.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_audiodev.obj : sdl_audiodev.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_mixer.obj : sdl_mixer.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_wave.obj : sdl_wave.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

clean :
        del *.obj;*
        del [...]*.obj;*
        del *.olb;*
$!
$!
$!
$COPY SYS$INPUT [.SRC.AUDIO.VMS]DESCRIP.MMS
.FIRST
        DEF MME MMOV$INCLUDE

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.AUDIO.VMS]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.-.include],[],MME) /OPT=(INLINE=SPEED) /DEFINE=(HAVE_CONFIG_H,IPC_VMS,LONG_BIT=64)  /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.AUDIO.VMS]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.-.include],[],MME,SYS$COMMON:[SYSHLP.EXAMPLES.MMOV.AUDIO]) /OPT=(INLINE=SPEED) /DEFINE=(HAVE_CONFIG_H,IPC_VMS,LONG_BIT=64)  /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.AUDIO.VMS]DESCRIP.MMS

ALL : sdl_vmsaudio.obj
	@ write sys$output "sdl_vmsaudio.obj created"

sdl_vmsaudio.obj : sdl_vmsaudio.c
        $(CC) $(CFLAGS) sdl_vmsaudio.c

clean :
        del *.obj;*
        del *.olb;*
  
$COPY SYS$INPUT [.SRC.AUDIO.DUMMY]DESCRIP.MMS

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.AUDIO.DUMMY]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H)  /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.AUDIO.DUMMY]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H)  /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.AUDIO.DUMMY]DESCRIP.MMS


sdl_dummyaudio.obj : sdl_dummyaudio.c
        $(CC) $(CFLAGS) sdl_dummyaudio.c

clean :
        del *.obj;*
        del *.olb;*
$!
$!

$COPY SYS$INPUT [.SRC.CDROM]DESCRIP.MMS
.FIRST
        set def [.VMS]
        $(mms)
        set def [-]

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.CDROM]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include], [.VMS])  /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.CDROM]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include], [.VMS])  /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.CDROM]DESCRIP.MMS

OBJ = sdl_cdrom.obj

ALL : libcdrom.olb
        cop libcdrom.olb [-]

libcdrom.olb : $(OBJ)
        lib/crea libcdrom.olb $(OBJ), [.VMS]sdl_syscdrom.OBJ

sdl_cdrom.obj : sdl_cdrom.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)


clean :
        del *.obj;*
        del *.olb;*
$!
$!
$COPY SYS$INPUT [.SRC.CDROM.VMS]DESCRIP.MMS
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.CDROM.VMS]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H)  /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.CDROM.VMS]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H)  /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.CDROM.VMS]DESCRIP.MMS

#All : SDL_SYSCDROM.OBJ

sdl_syscdrom.obj : sdl_syscdrom.c
        $(CC) $(CFLAGS) sdl_syscdrom.c

clean :
        del *.obj;*
        del *.olb;*
$!
$!
$COPY SYS$INPUT [.SRC.CPUINFO]DESCRIP.MMS
C=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.CPUINFO]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.CPUINFO]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.CPUINFO]DESCRIP.MMS


ALL : libcpuinfo.olb
        cop libcpuinfo.olb [-]

libcpuinfo.olb : sdl_cpuinfo.obj
        lib/cre libcpuinfo.olb sdl_cpuinfo.obj

sdl_cpuinfo.obj : sdl_cpuinfo.c
        $(CC) $(CFLAGS) sdl_cpuinfo.c

clean :
        del *.obj;*
        del *.olb;*
$!
$!
$!
$COPY SYS$INPUT [.SRC.CPUINFO]DESCRIP.MMS
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.CPUINFO]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.CPUINFO]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.CPUINFO]DESCRIP.MMS

ALL : libcpuinfo.olb
        cop libcpuinfo.olb [-]

libcpuinfo.olb : sdl_cpuinfo.obj
        lib/cre libcpuinfo.olb sdl_cpuinfo.obj

sdl_cpuinfo.obj : sdl_cpuinfo.c
        $(CC) $(CFLAGS) sdl_cpuinfo.c

clean :
        del *.obj;*
        del *.olb;*

$!
$!
$COPY SYS$INPUT [.SRC.EVENTS]DESCRIP.MMS
CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.EVENTS]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include], [-.TIMER],[-.JOYSTICK], [-.VIDEO]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.EVENTS]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include], [-.TIMER],[-.JOYSTICK], [-.VIDEO]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF

$       APP SYS$INPUT [.SRC.EVENTS]DESCRIP.MMS

OBJ = sdl_active.obj, sdl_events.obj, sdl_expose.obj, sdl_keyboard.obj, sdl_mouse.obj, sdl_quit.obj, sdl_resize.obj

ALL : libevents.olb
        cop libevents.olb [-]

libevents.olb : $(OBJ)
        LIB/CREA libevents.olb $(OBJ)

sdl_quit.obj : sdl_quit.c
        $(CC) $(CFLAGS) sdl_quit.c

sdl_resize.obj : sdl_resize.c
        $(CC) $(CFLAGS)  sdl_resize.c

sdl_active.obj : sdl_active.c
        $(CC) $(CFLAGS) sdl_active.c

sdl_events.obj : sdl_events.c
        $(CC) $(CFLAGS) sdl_events.c

sdl_expose.obj : sdl_expose.c
        $(CC) $(CFLAGS) sdl_expose.c

sdl_keyboard.obj : sdl_keyboard.c
        $(CC) $(CFLAGS) sdl_keyboard.c

sdl_mouse.obj : sdl_mouse.c
        $(CC) $(CFLAGS) sdl_mouse.c



clean :
        del *.obj;*
        del *.olb;*
$!
$!
$COPY SYS$INPUT [.SRC.FILE]DESCRIP.MMS
#
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.FILE]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.FILE]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.FILE]DESCRIP.MMS


ALL : libfile.olb
        cop libfile.olb [-]

libfile.olb : sdl_rwops.obj
        LIB/CREA libfile.olb sdl_rwops.obj

sdl_rwops.obj : sdl_rwops.c
        $(CC) $(CFLAGS) sdl_rwops.c

clean :
        del *.obj;*
        del *.olb;*
$!
$!
$COPY SYS$INPUT [.SRC.JOYSTICK]DESCRIP.MMS
#
#

.first
        set def [.DUMMY]
        $(mms)
        set def [-]

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.JOYSTICK]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include], [-.EVENTS],[.DUMMY]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.JOYSTICK]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include], [-.EVENTS],[.DUMMY]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.JOYSTICK]DESCRIP.MMS

OBJ = sdl_joystick.obj


ALL : libjoystick.olb
        cop libjoystick.olb [-]

libjoystick.olb : $(OBJ)
        lib/crea libjoystick.olb $(OBJ),[.DUMMY]sdl_sysjoystick.obj

sdl_joystick.obj : sdl_joystick.c
        $(CC) $(CFLAGS) sdl_joystick.c
	


clean :
        del *.obj;*
        del *.olb;*
$!
$!
$COPY SYS$INPUT [.SRC.JOYSTICK.DUMMY]DESCRIP.MMS
#
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.JOYSTICK.DUMMY]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.JOYSTICK.DUMMY]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.JOYSTICK.DUMMY]DESCRIP.MMS


sdl_sysjoystick.obj : sdl_sysjoystick.c
        $(CC) $(CFLAGS) sdl_sysjoystick.c

clean :
        del *.obj;*
        del *.olb;*
$!
$!
$COPY SYS$INPUT [.SRC.LOADSO]DESCRIP.MMS
.first
        set def [.DLOPEN]
        $(mms)
        set def [-]

ALL :
        $COP [.DLOPEN]*.olb [-]

clean :
        del [...]*.obj;*
        del [...]*.olb;*
$!
$!
$COPY SYS$INPUT [.SRC.LOADSO.DLOPEN]DESCRIP.MMS
#
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.LOADSO.DLOPEN]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H)  /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.LOADSO.DLOPEN]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H)  /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.LOADSO.DLOPEN]DESCRIP.MMS


ALL : libloadso.olb
        $!

sdl_sysloadso.obj : sdl_sysloadso.c
        $(CC) $(CFLAGS) sdl_sysloadso.c

libloadso.olb : sdl_sysloadso.obj
        LIB/CREA libloadso.olb sdl_sysloadso.obj

clean :
        del *.obj;*
        del *.olb;*

$!
$!
$COPY SYS$INPUT [.SRC.MAIN]DESCRIP.MMS
#
#
#

.first
        set def [.DUMMY]
        $(mms)
        set def [-]

ALL :
        cop libsdlmain.olb [-]

clean :
        del [...]*.obj;*
        del [...]*.olb;*

$!
$!
$COPY SYS$INPUT [.SRC.MAIN.DUMMY]DESCRIP.MMS
#
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.MAIN.DUMMY]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.MAIN.DUMMY]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.MAIN.DUMMY]DESCRIP.MMS


ALL : libsdlmain.olb
        $COP libsdlmain.olb [-]

sdl_dummy_main.obj : sdl_dummy_main.c
        $(CC) $(CFLAGS) sdl_dummy_main.c

libsdlmain.olb : sdl_dummy_main.obj
        LIB/CREA libsdlmain.olb sdl_dummy_main.obj

clean :
        del *.obj;*
        del *.olb;*
$!
$!
$COPY SYS$INPUT [.SRC.STDLIB]DESCRIP.MMS
#
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.STDLIB]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H,HAVE_GETENV,HAVE_MALLOC,HAVE_QSORT,HAVE_STRTOULL,HAVE_SSCANF,HAVE_LIBC) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.STDLIB]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include]) /DEFINE=(HAVE_CONFIG_H,HAVE_GETENV,HAVE_MALLOC,HAVE_QSORT,HAVE_STRTOULL,HAVE_SSCANF,HAVE_LIBC) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.STDLIB]DESCRIP.MMS

OBJS = sdl_getenv.obj, sdl_iconv.obj, \
       sdl_malloc.obj, sdl_qsort.obj, sdl_stdlib.obj, sdl_string.obj

ALL : stdlib.olb
        cop stdlib.olb [-]

stdlib.olb : $(OBJS)
        LIB/CREA stdlib.olb $(OBJS)

sdl_getenv.obj : sdl_getenv.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_iconv.obj : sdl_iconv.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_malloc.obj : sdl_malloc.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_qsort.obj : sdl_qsort.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_stdlib.obj : sdl_stdlib.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_string.obj : sdl_string.c
	$(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)


clean :
        del *.obj;*
        del *.olb;*

$!
$!
COPY SYS$INPUT [.SRC.THREAD]DESCRIP.MMS
#
.first
        set def [.PTHREAD]
        DEF LIBSDL [--]
        $(MMS)
        set def [-]
        DEF LIBSDL [-]

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.THREAD]DESCRIP.MMS
CFLAGS = /INCLUDE=([],[-],[-.-], [.PTHREAD],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.THREAD]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([],[-],[-.-], [.PTHREAD],[-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.THREAD]DESCRIP.MMS

ALL : libthread.olb
        cop libthread.olb [-]

libthread.olb : sdl_thread.obj
        LIB/CREA libthread.olb sdl_thread.obj,[.PTHREAD]sdl_syscond.obj, sdl_sysmutex.obj, sdl_syssem.obj, sdl_systhread.obj

sdl_thread.obj : sdl_thread.c
        $(CC) $(CFLAGS) sdl_thread.c


clean :
        del [...]*.obj;*
        del [...]*.olb;*

$!
$!
COPY SYS$INPUT [.SRC.THREAD.PTHREAD]DESCRIP.MMS
#
.FIRST
        DEFINE PTHREAD []

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.THREAD.PTHREAD]DESCRIP.MMS
CFLAGS = /INCLUDE=([],[-],[-.-], [-.-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.THREAD.PTHREAD]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([],[-],[-.-], [-.-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.THREAD.PTHREAD]DESCRIP.MMS

ALL :   libthread_generic.olb
        cop libthread_generic.olb [-.-]

libthread_generic.olb : sdl_syscond.obj, sdl_sysmutex.obj, sdl_syssem.obj, sdl_systhread.obj
        LIB/CREA libthread_generic.olb sdl_syscond.obj, sdl_sysmutex.obj, sdl_syssem.obj, sdl_systhread.obj

sdl_syscond.obj : sdl_syscond.c
        $(CC) $(CFLAGS) $(MMS$SOURCE)

sdl_sysmutex.obj : sdl_sysmutex.c
        $(CC) $(CFLAGS) $(MMS$SOURCE)

sdl_syssem.obj : sdl_syssem.c
        $(CC) $(CFLAGS) $(MMS$SOURCE)

sdl_systhread.obj : sdl_systhread.c
        $(CC) $(CFLAGS) $(MMS$SOURCE)


clean :
        del *.obj;*
        del *.olb;*
 
$!
$!
$COPY SYS$INPUT [.SRC.TIMER]DESCRIP.MMS
#
#

.first
        set def [.UNIX]
        $(mms)
        set def [-]

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.TIMER]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.include], [.VMS]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.TIMER]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.include], [.VMS]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.TIMER]DESCRIP.MMS

OBJ = sdl_timer.obj


ALL : libtimer.olb
        cop libtimer.olb [-]

libtimer.olb : $(OBJ)
        lib/crea libtimer.olb $(OBJ), [.UNIX]sdl_systimer.obj

sdl_timer.obj : sdl_timer.c
        $(CC) $(CFLAGS) $(MMS$SOURCE)


clean :
        del *.obj;*
        del *.olb;*
$!
$!
COPY SYS$INPUT [.SRC.TIMER.UNIX]DESCRIP.MMS
#
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.TIMER.UNIX]DESCRIP.MMS
CFLAGS = /INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB 
$ ELSE
$       APP SYS$INPUT [.SRC.TIMER.UNIX]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([-],[-.-.-.include]) /DEFINE=(HAVE_CONFIG_H) /DEB /FLOAT=IEEE
$ENDIF
$       APP SYS$INPUT [.SRC.TIMER.UNIX]DESCRIP.MMS


sdl_systimer.obj : sdl_systimer.c
        $(CC) $(CFLAGS) sdl_systimer.c

clean :
        del *.obj;*
        del *.olb;*
$!
$!
COPY SYS$INPUT [.SRC.VIDEO]DESCRIP.MMS
#
#

.first
        set def [.X11]
        $(mms)
        set def [-]

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.VIDEO]DESCRIP.MMS
CFLAGS = /INCLUDE=([],[-],[-.-.include], [-.EVENTS],[.X11], X11:) /DEFINE=(ENABLE_X11=1) /DEB /OPTIMIZE=(INLINE=SPEED)
$ ELSE
$       APP SYS$INPUT [.SRC.VIDEO]DESCRIP.MMS
CFLAGS = /name=(as_is,short)/INCLUDE=([],[-],[-.-.include], [-.EVENTS],[.X11], X11:) /DEFINE=(ENABLE_X11=1) /DEB /FLOAT=IEEE /OPTIMIZE=(INLINE=SPEED)
$ENDIF
$       APP SYS$INPUT [.SRC.VIDEO]DESCRIP.MMS

OBJ_X11 = [.x11]sdl_x11dga.obj,\
[.x11]sdl_x11events.obj,\
[.x11]sdl_x11gamma.obj,\
[.x11]sdl_x11gl.obj,\
[.x11]sdl_x11image.obj,\
[.x11]sdl_x11modes.obj,\
[.x11]sdl_x11mouse.obj,\
[.x11]sdl_x11video.obj,\
[.x11]sdl_x11wm.obj,\
[.x11]sdl_x11yuv.obj


OBJ = sdl_blit.obj,\
sdl_blit_0.obj,\
sdl_blit_1.obj,\
sdl_blit_a.obj,\
sdl_blit_n.obj,\
sdl_bmp.obj,\
sdl_cursor.obj,\
sdl_gamma.obj,\
sdl_pixels.obj,\
sdl_rleaccel.obj,\
sdl_stretch.obj,\
sdl_surface.obj,\
sdl_video.obj,\
sdl_yuv.obj,\
sdl_yuv_sw.obj



ALL : libvideo.olb
        cop libvideo.olb [-]

libvideo.olb : $(OBJ)
        lib/crea libvideo.olb $(OBJ)
        lib/ins  libvideo.olb $(OBJ_X11)

sdl_blit.obj : sdl_blit.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_blit_0.obj : sdl_blit_0.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_blit_1.obj : sdl_blit_1.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_blit_a.obj : sdl_blit_a.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_blit_n.obj : sdl_blit_n.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_bmp.obj : sdl_bmp.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_cursor.obj : sdl_cursor.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_gamma.obj : sdl_gamma.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_pixels.obj : sdl_pixels.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_rleaccel.obj : sdl_rleaccel.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_stretch.obj : sdl_stretch.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_surface.obj : sdl_surface.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_video.obj : sdl_video.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_yuv.obj : sdl_yuv.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_yuv_mmx.obj : sdl_yuv_mmx.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_yuv_sw.obj : sdl_yuv_sw.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

clean :
        del [...]*.obj;*
        del [...]*.olb;*
$!
$!
$!
COPY SYS$INPUT [.SRC.VIDEO.X11]DESCRIP.MMS
#
#

CC=cc

$IF CPU.EQS."VAX"
$ THEN
$       APP SYS$INPUT [.SRC.VIDEO.X11]DESCRIP.MMS
CFLAGS =  /INCLUDE=([-],[-.-.-.include],X11:, GL, [-.-.EVENTS]) /DEFINE=(ENABLE_X11=1) /DEB \
/OPTIMIZE=(INLINE=SPEED) /NOWARN
$ ELSE
$       APP SYS$INPUT [.SRC.VIDEO.X11]DESCRIP.MMS
CFLAGS =  /INCLUDE=([-],[-.-.-.include],X11:, GL, [-.-.EVENTS]) /DEFINE=(ENABLE_X11=1) /DEB /FLOAT=IEEE\
/name=(as_is,short)/OPTIMIZE=(INLINE=SPEED) /NOWARN
$ENDIF
$       APP SYS$INPUT [.SRC.VIDEO.X11]DESCRIP.MMS


OBJS = sdl_x11dga.obj,sdl_x11dyn.obj,sdl_x11events.obj,sdl_x11gamma.obj,\
	       sdl_x11gl.obj,sdl_x11image.obj,sdl_x11modes.obj,sdl_x11mouse.obj,\
               sdl_x11video.obj, sdl_x11wm.obj, sdl_x11yuv.obj

ALL : libvideo_x11.olb
        cop libvideo_x11.olb [-.-]

libvideo_x11.olb : $(OBJS)
        $LIB/CREA libvideo_x11 $(OBJS)

sdl_x11dga.obj : sdl_x11dga.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11dyn.obj : sdl_x11dyn.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11events.obj : sdl_x11events.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11gamma.obj : sdl_x11gamma.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11gl.obj : sdl_x11gl.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11image.obj : sdl_x11image.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11modes.obj : sdl_x11modes.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11mouse.obj : sdl_x11mouse.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11video.obj : sdl_x11video.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11wm.obj : sdl_x11wm.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sdl_x11yuv.obj : sdl_x11yuv.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)
 
clean :
        del *.obj;*
        del *.olb;*


$!
$!
$!
$WRITE SYS$OUTPUT "*******************************************"
$WRITW SYS$OUTPUT "Now type"
$WRITE SYS$OUTPUT "@BUILD"
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ del test.*;*
$ DEAS SYS$ERROR
$ DEAS SYS$OUTPUT
