#ifndef	__SD_COMM_H__
#define	__SD_COMM_H__

typedef	enum	{
					sdm_Off,
					sdm_PC,sdm_AdLib
				}	SDMode;
typedef	enum	{
					smm_Off,smm_AdLib
				}	SMMode;
typedef	enum	{
					sds_Off,sds_PC,sds_SoundBlaster
				}	SDSMode;

typedef struct
{
    longword	length;
    word	priority;
} SoundCommon;

typedef struct
{
    SoundCommon	common;
    byte	data[1];
} PCSound;

typedef struct
{
    SoundCommon	common;
    word	hertz;
    byte	bits;
    byte	reference;
    byte	data[1];
} SampledSound;

typedef struct
{
    byte	mChar;
    byte	cChar;
    byte	mScale;
    byte	cScale;
    byte	mAttack;
    byte	cAttack;
    byte	mSus;
    byte	cSus;
    byte	mWave;
    byte	cWave;
    byte	voice;
    byte	mode;
    byte	unused[3];
} Instrument;

typedef struct
{
    SoundCommon	common;
    Instrument	inst;
    byte	block;
    byte	data[1];
} AdLibSound;

extern boolean AdLibPresent, SoundBlasterPresent;

extern	SDMode		SoundMode;
extern	SDSMode		DigiMode;
extern	SMMode		MusicMode;

extern void SD_Startup();
extern void SD_Shutdown();

extern boolean SD_PlaySound(soundnames sound);
extern void SD_StopSound(),
				SD_WaitSoundDone(),
				SD_StartMusic(int music),
				SD_MusicOn(),
				SD_MusicOff();

extern boolean SD_SetSoundMode(SDMode mode), SD_SetMusicMode(SMMode mode);
		
extern word SD_SoundPlaying();

extern void SD_SetDigiDevice(SDSMode);

void PlaySoundLocGlobal(word s, int id, fixed gx, fixed gy);
void UpdateSoundLoc(fixed x, fixed y, int angle);

extern int DigiMap[];
void InitDigiMap();

#endif
