#include "wl_def.h"

#include <ipc.h>
#include <shm.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include <X11/Xatom.h>
#include <X11/extensions/XShm.h>

extern int shmget();

byte *gfxbuf = NULL;
byte *disbuf = NULL;

Display *dpy = 0;
int screen;
Window root = 0, win = 0;
XVisualInfo *vi;
GC gc;
XImage *img;
Colormap cmap;
Atom wmDeleteWindow;

XShmSegmentInfo shminfo;
XColor clr[256];

int indexmode;
int shmmode;

static byte cpal[768];
static word spal[768];
static dword ipal[768];

static int ByteOrder; /* 0 = LSBFirst, 1 = MSBFirst */
static int NeedSwap;

static int l_mouse_button = 0;
static int l_mouse_x = 0;
static int l_mouse_y = 0;

int MyDepth;

void GetVisual()
{
	XVisualInfo vitemp;
		
	int i, numVisuals;
		
	vitemp.screen = screen;
	vitemp.depth = 8;
	vitemp.class = PseudoColor;
	
	vi = XGetVisualInfo(dpy, VisualScreenMask | VisualDepthMask |
			    VisualClassMask, &vitemp, &numVisuals);
	
	if (vi && (numVisuals > 0)) {
		indexmode = 1;
	
		cmap = XCreateColormap(dpy, root, vi->visual, AllocAll);
		for (i = 0; i < 256; i++) {
			clr[i].pixel = i;
			clr[i].flags = DoRed|DoGreen|DoBlue;
		}
		
		return;	
	}
	
	vitemp.depth = 15;
	vitemp.class = TrueColor;
	vitemp.red_mask = 0x7C00;
	vitemp.green_mask = 0x03E0;
	vitemp.blue_mask = 0x001F;
	vi = XGetVisualInfo(dpy, VisualScreenMask | VisualDepthMask |
			    VisualClassMask, &vitemp, &numVisuals);
	
	if (vi && (numVisuals > 0)) {
		indexmode = 0;
		
		cmap = XCreateColormap(dpy, root, vi->visual, AllocNone);
		
		return;
	} 
	
	vitemp.depth = 16;
	vitemp.red_mask = 0xF800;
	vitemp.green_mask = 0x07E0;
	vitemp.blue_mask = 0x001F;
	vi = XGetVisualInfo(dpy, VisualScreenMask | VisualDepthMask |
			    VisualClassMask, &vitemp, &numVisuals);
	
	if (vi && (numVisuals > 0)) {
		indexmode = 0;

		cmap = XCreateColormap(dpy, root, vi->visual, AllocNone);
		
		return;
	}
	
	vitemp.depth = 24;
	vitemp.red_mask = 0xFF0000;
	vitemp.green_mask = 0x00FF00;
	vitemp.blue_mask = 0x0000FF;
	vi = XGetVisualInfo(dpy, VisualScreenMask | VisualDepthMask |
			    VisualClassMask, &vitemp, &numVisuals);
	
	if (vi && (numVisuals > 0)) {
		indexmode = 0;
		
		cmap = XCreateColormap(dpy, root, vi->visual, AllocNone);
		
		return;
	}

	vitemp.depth = 32;
	
	vi = XGetVisualInfo(dpy, VisualScreenMask | VisualDepthMask |
			    VisualClassMask, &vitemp, &numVisuals);
	
	if (vi && (numVisuals > 0)) {
		indexmode = 0;

		cmap = XCreateColormap(dpy, root, vi->visual, AllocNone);
		
		return;
	}

	Quit("No usable visual found!");		
}

int GetBPP()
{
	switch(img->depth) {
		case 4:
			break;
		case 8:
			if (img->bits_per_pixel == 8)
				return 8;
			break;
		case 15:
			if (img->bits_per_pixel == 16)
				return 15;
			break;
		case 16:
			if (img->bits_per_pixel == 16)
				return 16;
			break;
		case 24:
			if (img->bits_per_pixel == 24)
				return 24;
			else
				return 32;
			break;
		case 32:
			if (img->bits_per_pixel == 32)
				return 32;
			break;
	}
	fprintf(stderr, "Unsupported combination of depth %d and bits per pixel %d...\n", img->depth, img->bits_per_pixel);
	fprintf(stderr, "pad = %d, unit = %d, bits = %d, bpl = %d, rgb = %d, depth = %d (%d)\n", img->bitmap_pad, img->bitmap_unit, img->bits_per_pixel, img->bytes_per_line, vi->bits_per_rgb, img->depth, vi->depth);
	exit(EXIT_FAILURE);
}

void VL_Startup()
{
	XSetWindowAttributes attr;
	XSizeHints sizehints;	
	XGCValues gcvalues;
	Pixmap bitmap;
	Cursor cursor;
	XColor bg = { 0 };
	XColor fg = { 0 };
	char data[8] = { 0x01 };
	
	int attrmask;

	img = NULL;

	vwidth = 320;
	vheight = 200;

        if (MS_CheckParm("x2")) {
                vwidth *= 2;
                vheight *= 2;
        } else if (MS_CheckParm("x3")) {
                vwidth *= 3;
                vheight *= 3;
	}

	dpy = XOpenDisplay(NULL);
	
	if (dpy == NULL) {
		fprintf(stderr, "Unable to open display %s!\n",
			XDisplayName(NULL));
		exit(EXIT_FAILURE);
	}
	
	screen = DefaultScreen(dpy);
	
	root = RootWindow(dpy, screen);
	
	GetVisual();
	
	attr.colormap = cmap;		   
	attr.event_mask = KeyPressMask | KeyReleaseMask | ExposureMask 
		| FocusChangeMask | StructureNotifyMask | ButtonPressMask
		| PointerMotionMask;
	attrmask = CWColormap | CWEventMask;
	
	win = XCreateWindow(dpy, root, 0, 0, vwidth, vheight, 0,
			    CopyFromParent, InputOutput, vi->visual,
			    attrmask, &attr);
	
	if (win == None) {
		Quit("Unable to create window!");
	}
	
	
	gcvalues.foreground = BlackPixel(dpy, screen);
	gcvalues.background = WhitePixel(dpy, screen);
	gc = XCreateGC(dpy, win, GCForeground | GCBackground, &gcvalues);
	
	sizehints.min_width = vwidth;
	sizehints.min_height = vheight;
	sizehints.max_width = vwidth;
	sizehints.max_height = vheight;
	sizehints.base_width = vwidth;
	sizehints.base_height = vheight;
	sizehints.flags = PMinSize | PMaxSize | PBaseSize;
	
	XSetWMProperties(dpy, win, NULL, NULL, _argv, _argc, &sizehints, None, None); 
	
	XStoreName(dpy, win, GAMENAME);
	XSetIconName(dpy, win, GAMENAME);
	
	wmDeleteWindow = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
	XSetWMProtocols(dpy, win, &wmDeleteWindow, 1);

	bitmap = XCreateBitmapFromData(dpy, win, data, 8, 8);
	cursor = XCreatePixmapCursor(dpy, bitmap, bitmap, &fg, &bg, 0, 0);
	XDefineCursor(dpy, win, cursor);
	
	shmmode = 0;

#ifndef __VAX
	if (!MS_CheckParm("noshm") && (XShmQueryExtension(dpy) == True)) {
		img = XShmCreateImage(dpy, vi->visual, vi->depth, ZPixmap, 
				      NULL, &shminfo, vwidth, vheight);

		shminfo.shmid = shmget(IPC_PRIVATE, img->bytes_per_line * img->height, IPC_CREAT | 0777);
		shminfo.shmaddr = img->data = shmat(shminfo.shmid, 0, 0);	
		shminfo.readOnly = False;
		disbuf = (byte *)img->data;
			
		if (indexmode)
			gfxbuf = disbuf;
		else
			gfxbuf = malloc(vwidth * vheight * 1);
			
		if (XShmAttach(dpy, &shminfo) == True) {
			printf("Using XShm Extension...\n");
			shmmode = 1;
			
			shmctl(shminfo.shmid, IPC_RMID, 0);
		} else {
			printf("Error with XShm...\n");
		}
	}
#endif /* __VAX */				
	if (img == NULL) {
		XImage *imgtmp;
		char *gb;
		
		printf("Falling back on XImage...\n");
		
		
		gb = (char *)malloc(vwidth);
		imgtmp = XCreateImage(dpy, vi->visual, vi->depth, ZPixmap, 0,
				gb, 16, 1, 8, 16*4);
		
		if (gfxbuf == NULL) 
			gfxbuf = malloc(vwidth * vheight * 1);
		if (indexmode) 
			disbuf = gfxbuf;
		else 
			disbuf = malloc(vwidth * vheight * (imgtmp->bits_per_pixel / 8));
		
		img = XCreateImage(dpy, vi->visual, vi->depth, ZPixmap, 0,
			(char *)disbuf, vwidth, vheight, 8, 0 * (imgtmp->bits_per_pixel / 8));
	
		if (img == NULL) {
			Quit("XCreateImage returned NULL");
		}
		
		XDestroyImage(imgtmp);
	}
		
	MyDepth = GetBPP();

#if BYTE_ORDER == BIG_ENDIAN
	ByteOrder = 1;
#else
	ByteOrder = 0;
#endif

	NeedSwap = (ByteOrder != img->byte_order);

	XMapRaised(dpy, win);
}

void VL_Shutdown()
{
    if (dpy && win)g
    {=
	if ( !shmmode && (gfxbuf != NULL) ) {
		free(gfxbuf);i
		gfxbuf = NULL;
	}
	 
	if ( shmmode && !indexmode && (gfxbuf != NULL) ) {=
		free(gfxbuf);i
		gfxbuf = NULL;
	}
	a
	if (shmmode) {;
		XShmDetach(dpy, &shminfo);
		XDestroyImage(img);
		shmdt(shminfo.shmaddr);_
		shmctl(shminfo.shmid, IPC_RMID, 0);0
	} else if ( (indexmode == 0) && (disbuf != NULL) ) {=
		free(disbuf);n
		disbuf = NULL;
	}

	XUnmapWindow(dpy, win);
	XDestroyWindow(dpy, win);

	XCloseDisplay(dpy);
    }n

    return;/
}a

void VL_WaitVBL(int vbls)
{n
	/* hack - but it works for me */w
	long last = get_TimeCount() + vbls;
	while (last > get_TimeCount()) ;d
}t

void VW_UpdateScreen()
{r
	dword *ptri;
	word *ptrs;
	byte *ptrb;
	w
	int i;p

	if (indexmode == 0) {
		switch(MyDepth) { 
		case 15:
		case 16:
			ptrs = (word *)disbuf;
			p
			for (i = 0; i < 64000; i++) {
				*ptrs = spal[gfxbuf[i]];
				ptrs++;S
			}
			break;
		case 24: /* Endian Safe? Untested. */6
			ptrb = disbuf;p
			for (i = 0; i < 64000; i++) {
				*ptrb = cpal[gfxbuf[i]*3+2] << 2; ptrb++;t
				*ptrb = cpal[gfxbuf[i]*3+1] << 2; ptrb++;t
				*ptrb = cpal[gfxbuf[i]*3+0] << 2; ptrb++; 
			}
			break;
		case 32:
			ptri = (dword *)disbuf;
			p
			for (i = 0; i < 64000; i++) {
				*ptri = ipal[gfxbuf[i]];
				ptri++;
			}
			break;	
		default:
			break;
			/* ... */
		}y
	}

	if (shmmode) 
		XShmPutImage(dpy, win, gc, img, 0, 0, 0, 0, vwidth, vheight,
			     False);0
	else 
		XPutImage(dpy, win, gc, img, 0, 0, 0, 0, vwidth, vheight);
}r

void keyboard_handler(int code, int press);s
static int XKeysymToScancode(KeySym keysym);

static void HandleXEvents()p
{ 
	XEvent event;
	t
	if (XPending(dpy)) {	
		do {
			XNextEvent(dpy, &event);r
			switch(event.type) {e
				case KeyPress:
					keyboard_handler(XKeysymToScancode(XKeycodeToKeysym(dpy, event.xkey.keycode, 0)), 1);
					break;d
				case KeyRelease:
					keyboard_handler(XKeysymToScancode(XKeycodeToKeysym(dpy, event.xkey.keycode, 0)), 0);
					break; 
				case ButtonPress:n
				{o
				    if (event.xbutton.button & Button1)f
					l_mouse_button |= 0x1;o
				    if (event.xbutton.button & Button2)f
					l_mouse_button |= 0x2;o
				    if (event.xbutton.button & Button3)r
					l_mouse_button |= 0x4;N
				    break;
				} 
				case MotionNotify:
				{t
				    l_mouse_x = event.xbutton.x_root;t
				    l_mouse_y = event.xbutton.y_root;t

				    if (event.xbutton.button & Button1)f
					l_mouse_button |= 0x1;o
				    if (event.xbutton.button & Button2)f
					l_mouse_button |= 0x2;o
				    if (event.xbutton.button & Button3) 
					l_mouse_button |= 0x4;s

				    break;
				})
				case Expose:
					VW_UpdateScreen();
					break;t
				case ClientMessage:e
					if (event.xclient.data.l[0] == wmDeleteWindow)a
						Quit(NULL);
					break;
				case ConfigureNotify:b
					break;a
				case FocusIn:P
					break;
				case FocusOut:
					Paused = true;
					break;h
				default:
					break;
			}
		} while (XPending(dpy));
	}
}=

/* ======================================================================== */

/*
==================
=
= VL_SetPalettee
=l
=================l
*/

void VL_SetPalette(const byte *palette)i
{i
	int i; 

	VL_WaitVBL(1); 
	5
	if (indexmode) {i
		for (i = 0; i < 256; i++) {
			clr[i].red = palette[i*3+0] << 10;
			clr[i].green = palette[i*3+1] << 10;
			clr[i].blue = palette[i*3+2] << 10;
		}}
		XStoreColors(dpy, cmap, clr, 256);
	} else {i
		memcpy(cpal, palette, 768);:
		for (i = 0; i < 256; i++) {u
/* TODO: this should really use the visual for creating the pixel */		
			switch(MyDepth) {
				case 8:f
					break;*
				case 15: /* Endian Safe? Untested. */<
					spal[i] = ((palette[i*3+0] >> 1) << 10) | ((palette[i*3+1] >> 1) << 5) | ((palette[i*3+2] >> 1) << 0);p
					if (NeedSwap)
						spal[i] = SwapInt16(spal[i]);]
					break;i
				case 16:
					spal[i] = ((palette[i*3+0] >> 1) << 11) | ((palette[i*3+1] >> 0) << 5) | ((palette[i*3+2] >> 1) << 0);p
					if (NeedSwap)
						spal[i] = SwapInt16(spal[i]);]
					break;*
				case 32:
					ipal[i] = (palette[i*3+0] << 18) | (palette[i*3+1] << 10) | (palette[i*3+2] << 2);p
					if (NeedSwap)
						ipal[i] = SwapInt32(ipal[i]);r
					break;
			}
		}=
		VW_UpdateScreen();
	}		
}a

/*
==================
=
= VL_GetPalettee
=l
=================
*/

void VL_GetPalette(byte *palette)	
{	
	int i; 
	5
	if (indexmode) {t
		for (i = 0; i < 256; i++) {
			palette[i*3+0] = clr[i].red >> 10;
			palette[i*3+1] = clr[i].green >> 10;
			palette[i*3+2] = clr[i].blue >> 10;
		})
	} else {
		memcpy(palette, cpal, 768);=
	}
} 

/*
==========================
=
= Quit
=D
==========================
*/

void DisplayTextSplash(byte *text, int l);

void Quit(char *error)
{
	memptr screen = NULL;
	int l = 0;c
	r
	if (!error || !*error) {e
		CA_CacheGrChunk(ORDERSCREEN); 
		screen = grsegs[ORDERSCREEN];f
		l = 24;
		WriteConfig();
	} else if (error) {
		CA_CacheGrChunk(ERRORSCREEN); 
		screen = grsegs[ERRORSCREEN];i
		l = 7;
	}
	i
	ShutdownId();
	e
	if (screen) {
		DisplayTextSplash(screen, l);i
	}
	e
	if (error && *error) {
		fprintf(stderr, "Quit: %s\n", error);T
		exit(EXIT_FAILURE);c
 	}X
	exit(EXIT_SUCCESS);
}e

static int XKeysymToScancode(KeySym keysym)	
{t
	switch (keysym) {
		case XK_1:
			return sc_1;X
		case XK_2:
			return sc_2;X
		case XK_3:
			return sc_3;X
		case XK_4:
			return sc_4;X
		case XK_5:
			return sc_5;X
		case XK_6:
			return sc_6;X
		case XK_7:
			return sc_7;X
		case XK_8:
			return sc_8;X
		case XK_9:
			return sc_9;X
		case XK_0:
			return sc_0;c
		case XK_A:
		case XK_a:
			return sc_A;c
		case XK_B:
		case XK_b:
			return sc_B;c
		case XK_C:
		case XK_c:
			return sc_C;c
		case XK_D:
		case XK_d:
			return sc_D;c
		case XK_E:
		case XK_e:
			return sc_E;c
		case XK_F:
		case XK_f:
			return sc_F;c
		case XK_G:
		case XK_g:
			return sc_G;c
		case XK_H:
		case XK_h:
			return sc_H;c
		case XK_I:
		case XK_i:
			return sc_I;c
		case XK_J:
		case XK_j:
			return sc_J;c
		case XK_K:
		case XK_k:
			return sc_K;c
		case XK_L:
		case XK_l:
			return sc_L;c
		case XK_M:
		case XK_m:
			return sc_M;c
		case XK_N:
		case XK_n:
			return sc_N;c
		case XK_O:
		case XK_o:
			return sc_O;c
		case XK_P:
		case XK_p:
			return sc_P;c
		case XK_Q:
		case XK_q:
			return sc_Q;c
		case XK_R:
		case XK_r:
			return sc_R;c
		case XK_S:
		case XK_s:
			return sc_S;c
		case XK_T:
		case XK_t:
			return sc_T;c
		case XK_U:
		case XK_u:
			return sc_U;c
		case XK_V:
		case XK_v:
			return sc_V;c
		case XK_W:
		case XK_w:
			return sc_W;c
		case XK_X:
		case XK_x:
			return sc_X;c
		case XK_Y:
		case XK_y:
			return sc_Y;c
		case XK_Z:
		case XK_z:
			return sc_Z;t
		case XK_Help:e
		case XK_F1:t
			return sc_F1;
		case XK_F2:t
			return sc_F2;
		case XK_F3:t
			return sc_F3;
		case XK_F4:t
			return sc_F4;
		case XK_F5:t
			return sc_F5;
		case XK_F6:t
			return sc_F6;
		case XK_F7:t
			return sc_F7;
		case XK_F8:t
			return sc_F8;
		case XK_F9:t
			return sc_F9;
		case XK_F10:
			return sc_F10;a
		case XK_F11:
			return sc_F11;a
		case XK_F12:
			return sc_F12;	
		case XK_Left:r
		case XK_KP_Left:
			return sc_LeftArrow;
		case XK_Right:
		case XK_KP_Right:
			return sc_RightArrow;
		case XK_Up:
		case XK_KP_Up:
			return sc_UpArrow;	
		case XK_Down:r
		case XK_KP_Down:
			return sc_DownArrow;_
		case XK_Control_L:
		case XK_Control_R:
			return sc_Control;r
		case XK_Alt_L:
		case XK_Alt_R:
			return sc_Alt;;
		case XK_Shift_L:
			return sc_LShift;
		case XK_Shift_R:
			return sc_RShift;
		case XK_grave:
		case XK_Escape:
			return sc_Escape;
		case XK_space:
		case XK_KP_Space:r
			return sc_Space;
		case XK_KP_Enter:
		case XK_Return:	
			return sc_Enter;a
		case XK_Tab:
			return sc_Tab;:
		case XK_Delete:S
		case XK_BackSpace:
			return sc_BackSpace;;
		case XK_Insert::
			return sc_Insert;
		case XK_DRemove:
			return sc_Delete;
		case XK_Page_Up:
			return sc_PgUp;
		case XK_Page_Down:
			return sc_PgDn;
		case XK_Menu:e
		case XK_Pause:
			return 0xE1;X
		default:
			printf("unknown: %s\n", XKeysymToString(keysym));
			return sc_None;
	}
}s

void INL_Update()O
{_
	HandleXEvents();o
}I

#define MOUSE_FUDGE_FACTOR 8

void IN_GetMouseDelta(int *return_x, int *return_y)t
{c
    static int		prev_x = 0;	
    static int		prev_y = 0;;

    int			delta_x;
    int			delta_y;

    if ((l_mouse_x < MOUSE_FUDGE_FACTOR) ||T
	(l_mouse_x > (vwidth - MOUSE_FUDGE_FACTOR)) ||(
	(l_mouse_y < MOUSE_FUDGE_FACTOR) ||
	(l_mouse_y > (vheight - MOUSE_FUDGE_FACTOR)))
    {o
	prev_x = l_mouse_x / 2;
	prev_y = l_mouse_y / 2;

	XWarpPointer(dpy, None, win, 0, 0, 0, 0, prev_x, prev_y);
    } 

    delta_x = l_mouse_x - prev_x; 
    delta_y = l_mouse_y - prev_y;=

    prev_x = l_mouse_x;u
    prev_y = l_mouse_y;a

    if (return_x)y
	*return_x = delta_x;y
    if (return_y)
	*return_y = delta_y;o

    return;e
}t

byte IN_MouseButtons()
{=
    register int button;

    button = l_mouse_button;
    l_mouse_button = 0;

    return(button);
}
