## https://github.com/phoboslab/pl_mpeg 
## SDL1.2 fork for OpenVMS 

# PL_MPEG - MPEG1 Video decoder, MPEG-PS demuxer

Single-file MIT licensed library for C/C++

See [pl_mpeg.h](https://github.com/phoboslab/pl_mpeg/blob/master/pl_mpeg.h) for
the documentation.

## Why?

This is meant as a simple way to get video playback into your app or game. Other
solutions, such as ffmpeg require huge libraries and a lot of glue code.

MPEG1 is an old and inefficient codec, but it's still good enough for many use
cases. All patents related to MPEG1 and MP2 have expired, so it's completely
free now.

## Building on OpenVMS 8.4 Alpha and OpenVMS 9.2 x86_64 
## Tested in AlphaServer DS10 with 4MB ElsaGloria PCI 
## Compaq DEC HP AlphaServer ELSA Gloria PCI Graphic 298693-001 298796-001 PBXGK-BB 

Make sure you have SDL1.2 installed 

### Create WORKING SOURCE directory on your OpenVMS 
### Adjust accordingly to your environment 


$ set def DQB1:[000000] 
$ create/directory [.GAMES] 
$ create/directory [.GAMES.SRC] 
$ set def DQB1:[000000.GAMES.SRC] 

$ curl http://astr0baby.online/AXP/OpenVMS/SRC/sdl.zip -o sdl.zip 

$ unzip sdl.zip 

$ set def dqb1:[000000.GAMES.SRC.SDL] 
$ @configure.com 
$ @build.com 
$ DEFINE LIBSDL DQB1:[000000.GAMES.SRC.SDL.SRC] 
$ DEFINE SDL DQB1:[000000.GAMES.SRC.SDL.INCLUDE] 

$ set def dqb1:[000000.GAMES.SRC] 
$ curl http://astr0baby.online/AXP/OpenVMS/SRC/pl_mpeg.zip -o pl_mpeg.zip 
$ unzip pl_mpeg.zip 
$ set def dqb1:[000000.GAMES.SRC.PL_MPEG] 
$ @build.com 
$ mplayer :== $dqb1:[000000.GAMES.SRC.PL_MPEG]PL_MPEG.EXE 

### Play MPEG video 

$ mplayer video.mpg 

 
