#include <X11/Xlib.h>

#include "wl_def.h"
#include "id_ca.h"
#include "freqtbl.h"

#define PCSPKRTBL_MAX 256

extern Display		*dpy;

extern SDMode 		SoundMode;
extern soundnames	PlayingSound;

static int		pcspkrtbl[PCSPKRTBL_MAX];
static int		pcspkrtbl_loaded = 0;

void SD_StartXBell(void)
{
    int 		count;

    if (!pcspkrtbl_loaded)
    {
	pcspkrtbl[0] = 0;
	for (count = 1; count < PCSPKRTBL_MAX; ++count)
	    pcspkrtbl[count] = 1193100 / (count * 60);

	pcspkrtbl_loaded = 1;
    }

    return;
}

boolean SD_PlayXBell(void)
{
    int			count;
    XKeyboardControl	kbdctrl;
    XKeyboardState	kbdstate;
    PCSound		*sound;
    boolean		sstatus;
    byte		*stream;

    if (PlayingSound < 0)
	return(false);

    sstatus = true;

    sound = (PCSound *) audiosegs[STARTPCSOUNDS + PlayingSound];

    stream = sound->data;

    XGetKeyboardControl(dpy, &kbdstate);

    kbdctrl.bell_duration = 0;
    XChangeKeyboardControl(dpy, KBBellDuration, &kbdctrl);

    for (count = 0; count < sound->common.length; ++count)
    {
	if ((*stream) != *(stream - 1))
	{
	    kbdctrl.bell_pitch = pcspkrtbl[*stream];

	    XChangeKeyboardControl(dpy, KBBellPitch, &kbdctrl);
	}

	XBell(dpy, 0);

	if (PlayingSound == -1)
	    break;

	++stream;
    }

    kbdctrl.bell_pitch = kbdstate.bell_pitch;
    kbdctrl.bell_duration = kbdstate.bell_duration;

    XChangeKeyboardControl(dpy, KBBellPitch | KBBellDuration, &kbdctrl);

    return(sstatus);
}
